/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.google.common.collect.Sets;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.AbstractODataProcessor;
import com.sap.cds.adapter.odata.v4.processors.FastODataProcessor;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.OpenTelemetryUtils;
import com.sap.cds.services.utils.StringUtils;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.prefer.PreferencesApplied;
import org.apache.olingo.server.api.processor.ActionComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionComplexProcessor;
import org.apache.olingo.server.api.processor.ActionEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionEntityProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.ActionPrimitiveProcessor;
import org.apache.olingo.server.api.processor.ActionVoidProcessor;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.api.processor.ComplexCollectionProcessor;
import org.apache.olingo.server.api.processor.ComplexProcessor;
import org.apache.olingo.server.api.processor.CountEntityCollectionProcessor;
import org.apache.olingo.server.api.processor.DeltaProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.processor.ErrorProcessor;
import org.apache.olingo.server.api.processor.PrimitiveCollectionProcessor;
import org.apache.olingo.server.api.processor.PrimitiveValueProcessor;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlingoProcessor
implements EntityProcessor,
CountEntityCollectionProcessor,
ActionEntityProcessor,
ActionEntityCollectionProcessor,
PrimitiveValueProcessor,
PrimitiveCollectionProcessor,
ActionPrimitiveProcessor,
ActionPrimitiveCollectionProcessor,
ComplexProcessor,
ComplexCollectionProcessor,
ActionComplexProcessor,
ActionComplexCollectionProcessor,
ActionVoidProcessor,
BatchProcessor,
ErrorProcessor,
DeltaProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OlingoProcessor.class);
    private static final Logger accessLogger = LoggerFactory.getLogger((String)"com.sap.cds.adapter.odata.v4.BatchAccess");
    private static final Set<String> batchHeaderPropagationBlacklist = new HashSet<String>(Arrays.asList("Accept", "Accept-Encoding", "Accept-Charset", "Content-Type", "Content-Length", "Content-Encoding", "Content-Language", "Content-Location", "Content-ID", "Content-Transfer-Encoding", "MIME-Version", "If-Match", "If-None-Match"));
    private final CdsRequestGlobals globals;
    private final AbstractODataProcessor odataProcessor;

    public OlingoProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.odataProcessor = new FastODataProcessor(globals);
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
    }

    public void readEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processEntity(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readEntityCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processEntities(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void countEntityCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.handleUnsupportedOptions(uriInfo.asUriInfoResource());
        this.odataProcessor.processCountRequest(odataRequest, odataResponse, uriInfo);
    }

    private void handleUnsupportedOptions(UriInfoResource uriInfo) {
        if (uriInfo.getApplyOption() != null) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
        }
    }

    public void readComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleComplex(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionComplex(odataRequest, odataResponse, uriInfo, responseFormat, responseFormat);
    }

    public void readPrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitive(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readPrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitiveValue(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void readPrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionPrimitive(odataRequest, odataResponse, uriInfo, null, responseFormat);
    }

    public void createEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processEntity(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processEntity(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionEntityCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processEntities(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSingleComplex(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionComplex(odataRequest, odataResponse, uriInfo, responseFormat, responseFormat);
    }

    public void processActionPrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitive(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionPrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionPrimitive(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void processActionVoid(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, requestFormat);
    }

    public void updateEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processEntity(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void updateEntityCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processEntities(request, response, uriInfo, requestFormat, responseFormat);
    }

    public void updateComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    public void updateComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionComplex(odataRequest, odataResponse, uriInfo, responseFormat, responseFormat);
    }

    public void updatePrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitive(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void updatePrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processSinglePrimitiveValue(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void updatePrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo, ContentType requestFormat, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processCollectionPrimitive(odataRequest, odataResponse, uriInfo, requestFormat, responseFormat);
    }

    public void deleteEntity(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deleteComplex(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    public void deleteComplexCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deletePrimitive(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deletePrimitiveValue(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void deletePrimitiveCollection(ODataRequest odataRequest, ODataResponse odataResponse, UriInfo uriInfo) throws ODataApplicationException, ODataLibraryException {
        this.odataProcessor.processNoContentRequest(odataRequest, odataResponse, uriInfo, null);
    }

    public void processBatch(BatchFacade facade, ODataRequest odataRequest, ODataResponse odataResponse) throws ODataApplicationException, ODataLibraryException {
        boolean continueOnError = this.globals.getOData().createPreferences((Collection)odataRequest.getHeaders("Prefer")).hasContinueOnError();
        String boundary = facade.extractBoundaryFromContentType(odataRequest.getHeader("Content-Type"));
        BatchOptions options = BatchOptions.with().rawBaseUri(odataRequest.getRawBaseUri()).rawServiceResolutionUri(odataRequest.getRawServiceResolutionUri()).build();
        List parts = this.globals.getOData().createFixedFormatDeserializer().parseBatchRequest(odataRequest.getBody(), boundary, options);
        long requestSizeLimit = this.globals.getRuntime().getEnvironment().getCdsProperties().getOdataV4().getBatch().getMaxRequests();
        if (requestSizeLimit >= 0L && requestSizeLimit < parts.stream().mapToLong(p -> p.getRequests().size()).sum()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.BATCH_TOO_MANY_REQUESTS, new Object[0]);
        }
        ArrayList<ODataResponsePart> responseParts = new ArrayList<ODataResponsePart>();
        Set allowedParentHeaders = Sets.filter(odataRequest.getAllHeaders().keySet(), h -> batchHeaderPropagationBlacklist.stream().noneMatch(b -> h.equalsIgnoreCase((String)b)));
        block10: for (BatchRequestPart part : parts) {
            ODataResponsePart responsePart;
            for (ODataRequest req : part.getRequests()) {
                for (String header : allowedParentHeaders) {
                    String parentHeader;
                    if (!StringUtils.isEmpty((String)req.getHeader(header)) || StringUtils.isEmpty((String)(parentHeader = odataRequest.getHeader(header)))) continue;
                    req.addHeader(header, parentHeader);
                }
            }
            Optional span = part.getRequests().size() == 1 ? OpenTelemetryUtils.createSpan((OpenTelemetryUtils.CdsSpanType)OpenTelemetryUtils.CdsSpanType.ODATA_BATCH) : Optional.empty();
            span.ifPresent(s -> {
                ODataRequest request = (ODataRequest)part.getRequests().get(0);
                OlingoProcessor.updateSpan(request, s);
            });
            try (Scope scope = span.map(ImplicitContextKeyed::makeCurrent).orElse(null);){
                responsePart = facade.handleBatchRequest(part);
                span.ifPresent(s -> s.setAttribute(AttributeKey.longKey((String)"http.status_code"), ((ODataResponse)responsePart.getResponses().get(0)).getStatusCode()));
            }
            catch (Exception e) {
                OpenTelemetryUtils.recordException((Optional)span, (Exception)e);
                throw e;
            }
            finally {
                OpenTelemetryUtils.endSpan((Optional)span);
            }
            OlingoProcessor.logBatchRequest(part, responsePart);
            responseParts.add(responsePart);
            if (continueOnError) continue;
            for (ODataResponse response : responsePart.getResponses()) {
                int statusCode = response.getStatusCode();
                if (statusCode < 400 || statusCode > 600) continue;
                break block10;
            }
        }
        InputStream responseContent = this.globals.getOData().createFixedFormatSerializer().batchResponse(responseParts, boundary);
        odataResponse.setHeader("Content-Type", ContentType.MULTIPART_MIXED + ";boundary=" + boundary);
        odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(odataRequest));
        odataResponse.setContent(responseContent);
        odataResponse.setStatusCode(HttpStatusCode.OK.getStatusCode());
        if (continueOnError) {
            odataResponse.setHeader("Preference-Applied", PreferencesApplied.with().continueOnError().build().toValueString());
        }
    }

    public ODataResponsePart processChangeSet(BatchFacade facade, List<ODataRequest> odataRequests) throws ODataApplicationException, ODataLibraryException {
        try {
            return (ODataResponsePart)this.globals.getRuntime().changeSetContext().run(context -> {
                ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
                for (ODataRequest request : odataRequests) {
                    ODataResponse response;
                    Optional span = OpenTelemetryUtils.createSpan((OpenTelemetryUtils.CdsSpanType)OpenTelemetryUtils.CdsSpanType.ODATA_BATCH);
                    span.ifPresent(s -> {
                        OlingoProcessor.updateSpan(request, s);
                        s.setAttribute(OpenTelemetryUtils.CDS_ODATA_IS_CHANGESET, (Object)true);
                    });
                    try (Scope scope = span.map(ImplicitContextKeyed::makeCurrent).orElse(null);){
                        response = facade.handleODataRequest(request);
                        span.ifPresent(s -> s.setAttribute(OpenTelemetryUtils.HTTP_STATUS_CODE, response.getStatusCode()));
                    }
                    catch (ODataApplicationException | ODataLibraryException e) {
                        ErrorStatusException wrappedException = new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
                        OpenTelemetryUtils.recordException((Optional)span, (Exception)wrappedException);
                        throw wrappedException;
                    }
                    catch (Exception e) {
                        OpenTelemetryUtils.recordException((Optional)span, (Exception)e);
                        throw e;
                    }
                    finally {
                        OpenTelemetryUtils.endSpan((Optional)span);
                    }
                    if (response.getStatusCode() >= 200 && response.getStatusCode() < 400) {
                        responses.add(response);
                        continue;
                    }
                    return new ODataResponsePart(response, false);
                }
                return new ODataResponsePart(responses, true);
            });
        }
        catch (Exception e) {
            ODataResponse errorResponse = new ODataResponse();
            this.processError(odataRequests.get(0), errorResponse, ODataExceptionHelper.createServerErrorObject((Exception)e), ContentType.APPLICATION_JSON);
            return new ODataResponsePart(errorResponse, false);
        }
    }

    public void processError(ODataRequest odataRequest, ODataResponse odataResponse, ODataServerError serverError, ContentType responseFormat) {
        Locale locale = RequestContext.getCurrent((CdsRuntime)this.globals.getRuntime()).getParameterInfo().getLocale();
        try {
            CdsODataResponse cdsResponse;
            Exception exception = serverError.getException();
            if (exception instanceof ServiceException) {
                ServiceException serviceException = (ServiceException)exception;
                cdsResponse = ODataUtils.toErrorResponse(serviceException, this.globals);
            } else {
                String message;
                ErrorStatus errorStatus = ErrorStatuses.getByCode((int)serverError.getStatusCode());
                if (errorStatus == null) {
                    errorStatus = ErrorStatuses.SERVER_ERROR;
                }
                Object serviceException = StringUtils.isEmpty((String)(message = serverError.getMessage())) ? new ErrorStatusException(errorStatus, new Object[]{exception}) : new ServiceException(errorStatus, message, new Object[]{exception});
                cdsResponse = ODataUtils.toErrorResponse((ServiceException)serviceException, this.globals);
            }
            if (cdsResponse.getStatusCode() >= 500 && cdsResponse.getStatusCode() < 600) {
                if (exception != null) {
                    logger.error(exception.getMessage(), (Throwable)exception);
                } else {
                    logger.error(serverError.getMessage());
                }
            } else if (exception != null) {
                logger.debug(exception.getMessage(), (Throwable)exception);
            } else {
                logger.error(serverError.getMessage());
            }
            odataResponse.getAllHeaders().keySet().stream().collect(Collectors.toList()).stream().forEach(k -> odataResponse.setHeader(k, ""));
            ODataUtils.setODataErrorResponse(this.globals.getOData(), odataRequest, odataResponse, cdsResponse, null, responseFormat);
        }
        catch (Exception e) {
            logger.error("An unexpected error occurred during error processing", (Throwable)e);
            String message = new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale);
            String responseContent = "{\"error\":{\"code\":\"500\",\"message\":\"" + message + "\"}}";
            odataResponse.setContent(IOUtils.toInputStream((String)responseContent, (Charset)StandardCharsets.UTF_8));
            odataResponse.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            odataResponse.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
            odataResponse.setHeader("OData-Version", ODataUtils.getODataVersion(odataRequest));
        }
    }

    private static void logBatchRequest(BatchRequestPart requestPart, ODataResponsePart responsePart) {
        if (accessLogger.isInfoEnabled()) {
            List requests = requestPart.getRequests();
            List responses = responsePart.getResponses();
            for (int i = 0; i < requests.size(); ++i) {
                StringBuilder builder = new StringBuilder();
                ODataRequest request = (ODataRequest)requests.get(i);
                builder.append("$batch ");
                builder.append(request.getMethod()).append(" ");
                builder.append(request.getRawRequestUri().substring(request.getRawBaseUri().length()));
                ODataResponse response = responses.size() > i ? (ODataResponse)responses.get(i) : (ODataResponse)responses.get(0);
                builder.append(" ").append(response.getStatusCode());
                accessLogger.info(builder.toString());
            }
        }
    }

    private static void updateSpan(ODataRequest request, Span s) {
        String method = request.getMethod().name();
        String path = request.getRawODataPath();
        s.updateName(method + " " + path);
        s.setAttribute(OpenTelemetryUtils.HTTP_METHOD, (Object)method);
        s.setAttribute(OpenTelemetryUtils.HTTP_SCHEME, (Object)request.getProtocol());
        s.setAttribute(OpenTelemetryUtils.HTTP_TARGET, (Object)path);
        s.setAttribute(OpenTelemetryUtils.CDS_ODATA_IS_BATCH, (Object)true);
    }
}

