/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.Struct2JsonBuilder;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;
import com.sap.cds.impl.parser.token.Jsonizer;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Struct2Json
implements Data2Json<Map<String, Object>> {
    String2Json<Void> context;
    String2Json<Void> metadataEtag;
    String2Json<Map<String, Object>> etag;
    String2Json<Void> type;
    List<Data2Json<Map<String, Object>>> primitiveProperties;
    List<Data2Json<Map<String, Object>>> navigationLinkProperties;
    List<Data2Json<Map<String, Object>>> navigationProperties;
    List<Data2Json<Map<String, Object>>> dynamicProperties;
    Set<String> excludedProperties;
    boolean isOpenType;
    boolean isRootLevel = true;
    boolean isAutoExpand = false;
    Struct2JsonBuilder builder;

    Struct2Json() {
    }

    public String2Json<Void> getContext() {
        return this.context;
    }

    public String2Json<Void> getMetadataEtag() {
        return this.metadataEtag;
    }

    protected void writeProperties(Map<String, Object> row, JsonGenerator json) throws IOException {
        HashSet<String> rowProperties;
        HashSet<String> hashSet = rowProperties = this.isOpenType || this.isAutoExpand ? new HashSet<String>(row.keySet()) : null;
        if (this.primitiveProperties != null) {
            for (Data2Json<Map<String, Object>> p : this.primitiveProperties) {
                p.toJson(row, json);
                this.consumeProperty(rowProperties, p.getName());
            }
        }
        if (this.navigationLinkProperties != null) {
            for (Data2Json<Map<String, Object>> n : this.navigationLinkProperties) {
                n.toJson(row, json);
            }
        }
        if (this.navigationProperties != null) {
            for (Data2Json<Map<String, Object>> n : this.navigationProperties) {
                n.toJson(row, json);
                this.consumeProperty(rowProperties, n.getName());
            }
        }
        this.handleDynamicProperties(row, rowProperties, json);
    }

    private void handleDynamicProperties(Map<String, Object> row, Set<String> properties, JsonGenerator json) throws IOException {
        block6: {
            block5: {
                if (!this.isOpenType) break block5;
                for (String p : properties) {
                    Object pojo = row.get(p);
                    json.writeFieldName(p);
                    if (pojo == null) {
                        json.writeNull();
                        continue;
                    }
                    json.writeRawValue(Jsonizer.json((Object)pojo));
                }
                break block6;
            }
            if (properties == null) break block6;
            if (this.excludedProperties != null) {
                properties.removeAll(this.excludedProperties);
            }
            if (properties.size() > 0 && this.builder != null) {
                this.builder.addDynamicExpandProperties(this, properties);
                for (Data2Json<Map<String, Object>> n : this.dynamicProperties) {
                    n.toJson(row, json);
                }
            }
        }
    }

    private void consumeProperty(Set<String> rowProperties, String propertyName) {
        if (this.isAutoExpand || this.isOpenType) {
            rowProperties.remove(propertyName);
        }
    }
}

