/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.adapter.edmx.EdmxI18nProvider;
import com.sap.cds.adapter.edmx.EdmxProvider;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.metadata.CustomMetadataProcessor;
import com.sap.cds.adapter.odata.v4.metadata.CustomServiceDocumentProcessor;
import com.sap.cds.adapter.odata.v4.metadata.ODataExtendedEdmProvider;
import com.sap.cds.adapter.odata.v4.metadata.SimpleETagSupport;
import com.sap.cds.adapter.odata.v4.metadata.cds.CdsServiceEdmProvider;
import com.sap.cds.adapter.odata.v4.metadata.provider.LocalizingEdmxProviderWrapper;
import com.sap.cds.adapter.odata.v4.processors.OlingoProcessor;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.adapter.odata.v4.utils.QueryLimitUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.reflect.CdsDefinitionNotFoundException;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.path.CdsServicePath;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.api.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCdsODataServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCdsODataServlet.class);
    private static final String UNEXPECTED_ERROR_MESSAGE = "An unexpected error occurred during servlet processing";
    private final CdsRuntime runtime;
    private final String adapterBasePath;
    private final Map<String, ApplicationService> servicePaths;
    private final Supplier<EdmxProvider> edmxProviderSupplier;
    private final EdmxFlavourMapper.EdmxFlavour edmxFlavour;

    public AbstractCdsODataServlet(CdsRuntime runtime, String adapterBasePath, EdmxFlavourMapper.EdmxFlavour edmxFlavour, String protocolKey, Supplier<EdmxProvider> edmxProviderSupplier) {
        this.runtime = runtime;
        this.adapterBasePath = adapterBasePath;
        this.servicePaths = CdsServicePath.basePaths((CdsRuntime)runtime, (String)protocolKey);
        this.edmxProviderSupplier = edmxProviderSupplier;
        this.edmxFlavour = edmxFlavour;
        QueryLimitUtils.initialize(runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ParameterInfo parameterInfo = this.runtime.getProvidedParameterInfo();
        Locale locale = parameterInfo.getLocale();
        AtomicBoolean unclosedChangeSetTracker = new AtomicBoolean(false);
        try {
            this.runtime.requestContext().parameters(parameterInfo).run(context -> {
                CdsRequestGlobals requestGlobals = new CdsRequestGlobals(this.runtime, context.getModel(), unclosedChangeSetTracker, this.edmxFlavour);
                String pathInfo = req.getPathInfo();
                if (pathInfo == null) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_URI_RESOURCE, new Object[0]);
                }
                MutablePair<ApplicationService, String> serviceInfo = this.extractServiceInfo(pathInfo);
                ApplicationService applicationService = (ApplicationService)serviceInfo.getLeft();
                CdsService serviceDefinition = null;
                try {
                    serviceDefinition = applicationService.getDefinition();
                }
                catch (CdsDefinitionNotFoundException ex) {
                    throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[0]);
                }
                this.fillCdsEntityNamesMap(requestGlobals, serviceDefinition);
                String serviceName = serviceDefinition.getQualifiedName();
                String servicePath = (String)serviceInfo.getRight();
                requestGlobals.setApplicationService(applicationService);
                LocalizingEdmxProviderWrapper edmxProvider = new LocalizingEdmxProviderWrapper(this.edmxProviderSupplier.get(), (EdmxI18nProvider)this.runtime.getProvider(EdmxI18nProvider.class), locale);
                CsdlEdmProvider edm = edmxProvider.getEdmProvider(serviceName);
                if (edm == null) {
                    edm = new CdsServiceEdmProvider(serviceDefinition, requestGlobals.getEdmxFlavour());
                }
                edm = ODataExtendedEdmProvider.wrap(edm);
                OData odata = OData.newInstance();
                SimpleETagSupport etagSupport = new SimpleETagSupport(edmxProvider.getETag(serviceName));
                ServiceMetadata serviceMetadata = odata.createServiceMetadata(edm, Collections.emptyList(), (ServiceMetadataETagSupport)etagSupport);
                requestGlobals.setOData(odata);
                requestGlobals.setServiceMetadata(serviceMetadata);
                String searchMode = requestGlobals.getRuntime().getEnvironment().getCdsProperties().getOdataV4().getSearchMode();
                ODataHttpHandler odataHandler = odata.createHandler(serviceMetadata, Map.of("searchMode", searchMode));
                odataHandler.register((Processor)new OlingoProcessor(requestGlobals));
                odataHandler.register((Processor)new CustomServiceDocumentProcessor(this.runtime));
                odataHandler.register((Processor)new CustomMetadataProcessor(edmxProvider, serviceName));
                req.setAttribute("requestMapping", (Object)AbstractCdsODataServlet.getRequestMappingUrl(req, this.adapterBasePath, servicePath));
                odataHandler.process(req, resp);
            });
        }
        catch (ServiceException e) {
            int httpStatus = e.getErrorStatus().getHttpStatus();
            if (httpStatus >= 500 && httpStatus < 600) {
                logger.error(UNEXPECTED_ERROR_MESSAGE, (Throwable)e);
            } else {
                logger.debug(UNEXPECTED_ERROR_MESSAGE, (Throwable)e);
            }
            this.writeErrorResponse(req, resp, httpStatus, e.getLocalizedMessage(locale));
        }
        catch (Exception e) {
            logger.error(UNEXPECTED_ERROR_MESSAGE, (Throwable)e);
            this.writeErrorResponse(req, resp, 500, new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale));
        }
        finally {
            ChangeSetContext changeSetContext = ChangeSetContext.getCurrent();
            if (unclosedChangeSetTracker.get() && changeSetContext != null) {
                logger.warn("Closing a detected unclosed ChangeSet Context");
                try {
                    ((ChangeSetContextSPI)changeSetContext).close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @VisibleForTesting
    static String getRequestMappingUrl(HttpServletRequest request, String adapterBasePath, String servicePath) {
        String contextPath = request.getContextPath();
        String originalPath = request.getRequestURI();
        String newPath = UrlResourcePathBuilder.path((String[])new String[]{contextPath, adapterBasePath, servicePath}).build().getPath();
        if (originalPath.startsWith(newPath)) {
            return AbstractCdsODataServlet.rebuildUrl(request, newPath);
        }
        String remainderOfPath = originalPath.substring(contextPath.length());
        ArrayList<String> result = new ArrayList<String>();
        result.add(contextPath);
        Iterator segments = AbstractCdsODataServlet.splitPathSegments(remainderOfPath).iterator();
        Stream.concat(AbstractCdsODataServlet.splitPathSegments(adapterBasePath), AbstractCdsODataServlet.splitPathSegments(servicePath)).forEach(s -> {
            String next;
            if (segments.hasNext() && s.equals(URLDecoder.decode(next = (String)segments.next(), StandardCharsets.UTF_8))) {
                result.add(next);
                return;
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_URI_RESOURCE, new Object[0]);
        });
        return AbstractCdsODataServlet.rebuildUrl(request, UrlResourcePathBuilder.path((String[])result.toArray(new String[0])).build().getPath());
    }

    private static String rebuildUrl(HttpServletRequest request, String path) {
        try {
            URI original = URI.create(request.getRequestURL().toString());
            return new URI(original.getScheme(), original.getUserInfo(), original.getHost(), original.getPort(), null, null, null).resolve(path).toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private static Stream<String> splitPathSegments(String from) {
        return Stream.of(from.split("/")).dropWhile(String::isBlank);
    }

    private void fillCdsEntityNamesMap(CdsRequestGlobals requestGlobals, CdsService serviceDefinition) {
        serviceDefinition.entities().forEach(entity -> {
            String cdsName = entity.getName();
            String edmName = com.sap.cds.services.utils.ODataUtils.toODataName((String)cdsName);
            if (!edmName.equals(cdsName)) {
                String key = entity.getQualifier() + "." + edmName;
                String value = entity.getQualifier() + "." + cdsName;
                requestGlobals.getCdsEntityNames().put(key, value);
            }
        });
    }

    private void writeErrorResponse(HttpServletRequest req, HttpServletResponse resp, int httpStatus, String message) throws IOException {
        String responseContent = "{\"error\":{\"code\":\"" + httpStatus + "\",\"message\":\"" + message + "\"}}";
        resp.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
        resp.setHeader("OData-Version", ODataUtils.getODataVersion(req.getHeader("OData-Version"), req.getHeader("OData-MaxVersion")));
        resp.setStatus(httpStatus);
        resp.getWriter().println(responseContent);
    }

    private MutablePair<ApplicationService, String> extractServiceInfo(String pathInfo) {
        String servicePath;
        ApplicationService service;
        if (pathInfo.trim().isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[0]);
        }
        String path = StringUtils.trim((String)pathInfo.trim(), (char)'/');
        Optional<String> servicePathKey = this.servicePaths.keySet().stream().sorted((a, b) -> -1 * Integer.compare(a.length(), b.length())).filter(p -> path.equals(p) || path.startsWith(p + "/")).findFirst();
        if (servicePathKey.isPresent() && (service = this.servicePaths.get(servicePath = servicePathKey.get())) != null) {
            return MutablePair.of((Object)service, (Object)servicePath);
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{path});
    }
}

