/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4;

import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.path.CdsResourcePath;
import com.sap.cds.services.utils.path.CdsServicePath;
import com.sap.cds.services.utils.path.UrlPathUtil;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;
import jakarta.servlet.Servlet;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

abstract class AbstractCdsODataServletFactory
implements ServletAdapterFactory,
CdsRuntimeAware {
    private final String protocolKey;
    private final Function<CdsRuntime, CdsProperties.Servlet> configProvider;
    private final BiFunction<CdsRuntime, String, Servlet> servletProvider;
    private CdsRuntime runtime;

    AbstractCdsODataServletFactory(String protocolKey, Function<CdsRuntime, CdsProperties.Servlet> configProvider, BiFunction<CdsRuntime, String, Servlet> servletProvider) {
        this.protocolKey = protocolKey;
        this.configProvider = configProvider;
        this.servletProvider = servletProvider;
    }

    public void setCdsRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public Object create() {
        return this.servletProvider.apply(this.runtime, this.getBasePath());
    }

    public boolean isEnabled() {
        return this.configProvider.apply(this.runtime).isEnabled();
    }

    public String getBasePath() {
        return UrlPathUtil.normalizeBasePath((String)this.configProvider.apply(this.runtime).getPath());
    }

    public String[] getMappings() {
        Stream cdsServicePaths = CdsServicePath.servicePaths((CdsRuntime)this.runtime, (String)this.protocolKey);
        return (String[])cdsServicePaths.map(servicePath -> UrlResourcePathBuilder.path((String[])new String[]{this.getBasePath(), servicePath.getPath()}).recursive().build().getPath()).toArray(String[]::new);
    }

    public UrlResourcePath getServletPath() {
        boolean openMetadataEndpoint = !this.runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().isAuthenticateMetadataEndpoints();
        Stream cdsServicePaths = CdsServicePath.servicePaths((CdsRuntime)this.runtime, (String)this.protocolKey);
        return UrlResourcePathBuilder.path((String[])new String[]{this.getBasePath()}).recursive().subPaths(cdsServicePaths.flatMap(cdsServicePath -> {
            boolean servicePublic = cdsServicePath.isPublic() && !cdsServicePath.subPaths().anyMatch(p -> !p.isPublic());
            return Stream.of(UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "$metadata"}).isPublic(openMetadataEndpoint || cdsServicePath.isPublic()).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "$batch"}).isPublic(servicePublic).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "$all"}).recursive().isPublic(servicePublic).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "$crossjoin"}).recursive().isPublic(servicePublic).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath()}).isPublic(cdsServicePath.isPublic()).subPaths(cdsServicePath.subPaths().flatMap(cdsSubPath -> {
                if (cdsSubPath.hasType(CdsEntity.class)) {
                    return Stream.of(UrlResourcePathBuilder.path((String[])new String[]{ODataUtils.toODataName((String)cdsSubPath.getPath())}).recursive().isPublic(cdsServicePath.isPublic() && cdsSubPath.isPublic()).publicEvents(cdsSubPath.publicEvents().map(UrlPathUtil::cdsEvent2HttpMethod).filter(Objects::nonNull)).subPaths(cdsSubPath.subPaths().flatMap(p -> AbstractCdsODataServletFactory.actionOrFunction(cdsSubPath, p, cdsServicePath.isPublic() && cdsSubPath.isPublic()))).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsSubPath.getPath() + "(*)"}).recursive().isPublic(cdsServicePath.isPublic() && cdsSubPath.isPublic()).publicEvents(cdsSubPath.publicEvents().map(UrlPathUtil::cdsEvent2HttpMethod).filter(Objects::nonNull)).subPaths(cdsSubPath.subPaths().flatMap(p -> AbstractCdsODataServletFactory.actionOrFunction(cdsSubPath, p, cdsServicePath.isPublic() && cdsSubPath.isPublic()))).build());
                }
                return AbstractCdsODataServletFactory.actionOrFunction(cdsServicePath, cdsSubPath, cdsServicePath.isPublic());
            })).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "/"}).isPublic(cdsServicePath.isPublic()).build());
        })).build();
    }

    private static Stream<UrlResourcePath> actionOrFunction(CdsResourcePath parentPath, CdsResourcePath actionFunctionPath, boolean parentsArePublic) {
        if (actionFunctionPath.hasType(CdsAction.class) || actionFunctionPath.hasType(CdsFunction.class)) {
            Object actionOrFunctionPath = actionFunctionPath.getPath();
            if (parentPath.hasType(CdsEntity.class)) {
                actionOrFunctionPath = parentPath.getCdsDefinition().getQualifier() + "." + actionFunctionPath.getPath();
            }
            String httpMethod = actionFunctionPath.hasType(CdsAction.class) ? UrlPathUtil.HttpMethod.POST.name() : UrlPathUtil.HttpMethod.GET.name();
            return Stream.of(UrlResourcePathBuilder.path((String[])new String[]{actionOrFunctionPath}).isPublic(false).publicEvents(parentsArePublic && actionFunctionPath.isPublic() ? Stream.of(httpMethod) : Stream.empty()).build(), UrlResourcePathBuilder.path((String[])new String[]{(String)actionOrFunctionPath + "(*)"}).isPublic(false).publicEvents(parentsArePublic && actionFunctionPath.isPublic() ? Stream.of(httpMethod) : Stream.empty()).build());
        }
        return Stream.empty();
    }
}

