/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.path.CdsServicePath;
import com.sap.cds.services.utils.path.UrlPathUtil;
import java.io.PrintWriter;
import java.util.stream.Stream;

public class ODataX4IndexContentProvider
implements IndexContentProvider {
    private static final String SERVICE = "                <h3 class=\"header\">\n                    <a href=\"%s/\"><span>%s</span></a><span>/</span><a href=\"%s/$metadata\"><span class=\"metadata\">$metadata</span></a>\n                </h3>\n";
    private static final String ENTITY_START = "                <ul>\n";
    private static final String ENTITY = "                    <li>\n                        <div><a href=\"%s\"><span>%s</span></a></div>\n                    </li>\n";
    private static final String ENTITY_END = "                </ul>\n";
    private final CdsRuntime runtime;

    public ODataX4IndexContentProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public String getSectionTitle() {
        return "OData X4 endpoints";
    }

    public int order() {
        return -5;
    }

    public void writeContent(PrintWriter out, String contextPath) {
        Stream cdsServicePaths = CdsServicePath.servicePaths((CdsRuntime)this.runtime, (String)"odata-x4");
        String basePath = UrlPathUtil.normalizeBasePath((String)this.runtime.getEnvironment().getCdsProperties().getOdataX4().getEndpoint().getPath());
        String theBasePath = contextPath + (basePath.equals("/") ? "" : basePath);
        cdsServicePaths.filter(p -> p.getCdsDefinition() instanceof CdsService).sorted().forEach(s -> {
            String path = theBasePath + "/" + s.getPath();
            out.format(SERVICE, path, path, path);
            out.write(ENTITY_START);
            s.subPaths().filter(e -> ODataX4IndexContentProvider.isExposedEntity(e.getCdsDefinition())).sorted().forEach(e -> {
                String odataEntity = ODataUtils.toODataName((String)e.getPath());
                String entityPath = path + "/" + odataEntity;
                out.format(ENTITY, entityPath, e.getPath());
            });
            out.write(ENTITY_END);
        });
    }

    public static boolean isExposedEntity(CdsDefinition definition) {
        if (definition instanceof CdsEntity) {
            CdsEntity entity = (CdsEntity)definition;
            boolean autoexposed = CdsAnnotations.AUTOEXPOSED.isTrue((CdsAnnotatable)definition);
            boolean autoexpose = CdsAnnotations.AUTOEXPOSE.isTrue((CdsAnnotatable)definition);
            String name = definition.getName();
            return !name.endsWith("_drafts") && !name.endsWith("_texts") && !name.endsWith(".texts") && !name.endsWith("DraftAdministrativeData") && (DraftUtils.isDraftEnabled((CdsAnnotatable)entity) || !autoexposed || autoexpose);
        }
        return false;
    }
}

