/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.cds;

import com.sap.cds.adapter.odata.v4.metadata.cds.CdsServiceEdmUtils;
import com.sap.cds.adapter.odata.v4.utils.ElementUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlBindingTarget;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNamed;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;

class CdsServiceEdmEntityContainer
extends CsdlEntityContainer {
    static final String ENTITY_CONTAINER_NAME = "EntityContainer";
    private final EdmxFlavourMapper.EdmxFlavour flavour;
    private final EdmxFlavourMapper flavourMapper;
    private final Map<String, CdsEntity> entityLookup = new HashMap<String, CdsEntity>();
    private final Map<String, CdsAction> actionLookup = new HashMap<String, CdsAction>();
    private final Map<String, CdsFunction> functionLookup = new HashMap<String, CdsFunction>();
    private final Map<CdsDefinition, CsdlNamed> cached = new HashMap<CdsDefinition, CsdlNamed>();

    CdsServiceEdmEntityContainer(CdsService service, EdmxFlavourMapper.EdmxFlavour flavour, EdmxFlavourMapper flavourMapper) {
        this.flavour = flavour;
        this.flavourMapper = flavourMapper;
        service.entities().filter(CdsServiceEdmUtils::isIncludedEntitySet).forEach(e -> this.entityLookup.put(CdsServiceEdmUtils.name((CdsDefinition)e), (CdsEntity)e));
        service.actions().forEach(a -> this.actionLookup.put(CdsServiceEdmUtils.name((CdsDefinition)a), (CdsAction)a));
        service.functions().forEach(f -> this.functionLookup.put(CdsServiceEdmUtils.name((CdsDefinition)f), (CdsFunction)f));
        this.setName(ENTITY_CONTAINER_NAME);
        this.setEntitySets(null);
        this.setSingletons(null);
        this.setActionImports(null);
        this.setFunctionImports(null);
    }

    public CsdlEntitySet getEntitySet(String name) {
        CdsEntity entity = this.entityLookup.get(name);
        if (entity != null && !CdsAnnotations.SINGLETON.isTrue((CdsAnnotatable)entity)) {
            return (CsdlEntitySet)this.buildBindingTarget(entity);
        }
        return null;
    }

    public List<CsdlEntitySet> getEntitySets() {
        return this.entityLookup.values().stream().filter(e -> !CdsAnnotations.SINGLETON.isTrue((CdsAnnotatable)e)).map(e -> (CsdlEntitySet)this.buildBindingTarget((CdsEntity)e)).toList();
    }

    public CsdlSingleton getSingleton(String name) {
        CdsEntity entity = this.entityLookup.get(name);
        if (entity != null && CdsAnnotations.SINGLETON.isTrue((CdsAnnotatable)entity)) {
            return (CsdlSingleton)this.buildBindingTarget(entity);
        }
        return null;
    }

    public List<CsdlSingleton> getSingletons() {
        return this.entityLookup.values().stream().filter(arg_0 -> ((CdsAnnotations)CdsAnnotations.SINGLETON).isTrue(arg_0)).map(e -> (CsdlSingleton)this.buildBindingTarget((CdsEntity)e)).toList();
    }

    private CsdlBindingTarget buildBindingTarget(CdsEntity entity) {
        return (CsdlBindingTarget)this.cached.computeIfAbsent((CdsDefinition)entity, e -> {
            boolean isParameterized = CdsServiceEdmUtils.isParameterized(entity);
            Object bindingTarget = CdsAnnotations.SINGLETON.isTrue((CdsAnnotatable)entity) ? new CsdlSingleton() : new CsdlEntitySet();
            bindingTarget.setName(CdsServiceEdmUtils.name((CdsDefinition)entity));
            bindingTarget.setType(CdsServiceEdmUtils.fqn((CdsDefinition)entity) + (isParameterized ? "Parameters" : ""));
            this.flavourMapper.createMappings((CdsStructuredType)entity).forEach(arg_0 -> this.lambda$buildBindingTarget$8(isParameterized, entity, (CsdlBindingTarget)bindingTarget, arg_0));
            if (isParameterized) {
                CsdlNavigationPropertyBinding parametersBinding = new CsdlNavigationPropertyBinding();
                parametersBinding.setPath("Set/Parameters");
                parametersBinding.setTarget(CdsServiceEdmUtils.name((CdsDefinition)entity));
                bindingTarget.getNavigationPropertyBindings().add(parametersBinding);
            }
            return bindingTarget;
        });
    }

    public CsdlActionImport getActionImport(String name) {
        CdsAction action = this.actionLookup.get(name);
        if (action != null) {
            return this.buildActionImport(action);
        }
        return null;
    }

    public List<CsdlActionImport> getActionImports(String name) {
        return List.of(this.getActionImport(name));
    }

    public List<CsdlActionImport> getActionImports() {
        return this.actionLookup.values().stream().map(this::buildActionImport).toList();
    }

    private CsdlActionImport buildActionImport(CdsAction action) {
        return (CsdlActionImport)this.cached.computeIfAbsent((CdsDefinition)action, a -> {
            CsdlActionImport actionImport = new CsdlActionImport();
            actionImport.setAction(CdsServiceEdmUtils.fqn((CdsDefinition)action));
            actionImport.setName(CdsServiceEdmUtils.name((CdsDefinition)action));
            action.returnType().filter(r -> r.getKind() == CdsKind.ENTITY).map(r -> CdsServiceEdmUtils.name((CdsDefinition)r)).ifPresent(arg_0 -> ((CsdlActionImport)actionImport).setEntitySet(arg_0));
            return actionImport;
        });
    }

    public CsdlFunctionImport getFunctionImport(String name) {
        CdsFunction function = this.functionLookup.get(name);
        if (function != null) {
            return this.buildFunctionImport(function);
        }
        return null;
    }

    public List<CsdlFunctionImport> getFunctionImports(String name) {
        return List.of(this.getFunctionImport(name));
    }

    public List<CsdlFunctionImport> getFunctionImports() {
        return this.functionLookup.values().stream().map(this::buildFunctionImport).toList();
    }

    private CsdlFunctionImport buildFunctionImport(CdsFunction function) {
        return (CsdlFunctionImport)this.cached.computeIfAbsent((CdsDefinition)function, f -> {
            CsdlFunctionImport functionImport = new CsdlFunctionImport();
            functionImport.setFunction(CdsServiceEdmUtils.fqn((CdsDefinition)function));
            functionImport.setName(CdsServiceEdmUtils.name((CdsDefinition)function));
            if (function.getReturnType().getKind() == CdsKind.ENTITY) {
                functionImport.setEntitySet(CdsServiceEdmUtils.name((CdsDefinition)function.getReturnType()));
            }
            return functionImport;
        });
    }

    private /* synthetic */ void lambda$buildBindingTarget$8(boolean isParameterized, CdsEntity entity, CsdlBindingTarget bindingTarget, EdmxFlavourMapper.Mapping mapping) {
        if (CdsServiceEdmUtils.isIncludedEntitySetAssociation(mapping.getTargetElement())) {
            CsdlNavigationPropertyBinding binding = new CsdlNavigationPropertyBinding();
            binding.setPath((isParameterized ? "Set/" : "") + mapping.getEdmxName());
            binding.setTarget(CdsServiceEdmUtils.name((CdsDefinition)CdsServiceEdmUtils.target((CdsStructuredType)entity, mapping.getTargetElement())));
            bindingTarget.getNavigationPropertyBindings().add(binding);
        } else if (this.flavour == EdmxFlavourMapper.EdmxFlavour.X4 && mapping.getRootElement().getType().isStructured()) {
            String elementName = mapping.getRootElement().getName();
            CdsStructuredType type = (CdsStructuredType)mapping.getRootElement().getType().as(CdsStructuredType.class);
            ElementUtils.recursiveElements(type, a -> a.getType().isAssociation()).forEach((path, assoc) -> {
                CsdlNavigationPropertyBinding binding = new CsdlNavigationPropertyBinding();
                binding.setPath(elementName + "/" + path.replace('.', '/'));
                binding.setTarget(CdsServiceEdmUtils.name((CdsDefinition)CdsServiceEdmUtils.target(null, assoc)));
                bindingTarget.getNavigationPropertyBindings().add(binding);
            });
        }
    }
}

