/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.provider.OlingoAwareEdmxProvider;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;

public abstract class AbstractDefaultEdmxProvider
implements OlingoAwareEdmxProvider {
    private final Map<String, MetadataInfo> metadataInfoMap = new ConcurrentHashMap<String, MetadataInfo>();
    private final CdsRuntime runtime;
    private final String basePath;

    public AbstractDefaultEdmxProvider(CdsRuntime runtime, String basePath) {
        this.runtime = runtime;
        this.basePath = basePath;
    }

    public String getETag(String serviceName) {
        return this.getMetadataInfo(serviceName).getETag();
    }

    public InputStream getEdmx(String serviceName) {
        return this.getMetadataInfo(serviceName).getEdmx();
    }

    @Override
    public CsdlEdmProvider getEdmProvider(String serviceName) {
        return this.getMetadataInfo(serviceName).getEdmProvider();
    }

    MetadataInfo getMetadataInfo(String serviceName) {
        Locale locale = RequestContext.getCurrent((CdsRuntime)this.runtime).getParameterInfo().getLocale();
        MetadataInfo info = this.getMetadataInfo(serviceName, locale);
        if (locale != null && info.isEmpty()) {
            info = this.getMetadataInfo(serviceName, null);
        }
        if (info.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA, new Object[]{serviceName});
        }
        return info;
    }

    private MetadataInfo getMetadataInfo(String unlocalizedServiceName, Locale locale) {
        Object serviceName;
        if (locale != null) {
            String language = LocaleUtils.getLocaleForBundle((Locale)locale).toString();
            serviceName = unlocalizedServiceName + "_" + language;
        } else {
            serviceName = unlocalizedServiceName;
        }
        return this.metadataInfoMap.computeIfAbsent((String)serviceName, arg_0 -> this.lambda$getMetadataInfo$0((String)serviceName, arg_0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ MetadataInfo lambda$getMetadataInfo$0(String serviceName, String key) {
        try {
            String resourcePathToEdmx = this.basePath + "/" + serviceName + ".xml";
            try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream(resourcePathToEdmx);){
                if (resource == null) return MetadataInfo.create(serviceName, null, this.runtime);
                MetadataInfo metadataInfo = MetadataInfo.create(serviceName, resource.readAllBytes(), this.runtime);
                return metadataInfo;
            }
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA, new Object[]{serviceName, e});
        }
    }
}

