/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.google.common.hash.Hashing;
import com.sap.cds.adapter.edmx.EdmxI18nProvider;
import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.provider.DefaultEdmxI18nProvider;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.lib.mtx.MetaDataAccessor;
import com.sap.cds.services.utils.lib.mtx.ModelId;
import com.sap.cds.services.utils.lib.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Map;

class DynamicEdmxI18nProvider
implements EdmxI18nProvider {
    private final CdsRuntime runtime;
    private final DynamicModelUtils utils;
    private final EdmxI18nProvider previous;
    private final MetaDataAccessor<MetadataInfo> accessor;

    public DynamicEdmxI18nProvider(CdsRuntime runtime, DynamicModelUtils utils, final DefaultEdmxI18nProvider previous) {
        this.runtime = runtime;
        this.utils = utils;
        this.previous = previous;
        this.accessor = utils.createMetadataAccessor(null, null, new MetaDataAccessorImpl.I18nResourceCreator(){

            public MetaDataAccessor.I18n parse(String json, String language) {
                String eTag = Hashing.sha256().hashUnencodedChars((CharSequence)json).toString();
                Map texts = (Map)JsonParser.map((Reader)new StringReader(json));
                return new MetaDataAccessor.I18n(eTag, texts);
            }

            public MetaDataAccessor.I18n getBaseModel(String language) {
                return new MetaDataAccessor.I18n(previous.getETag(language), previous.getTexts(language));
            }
        });
    }

    public String getETag(Locale locale) {
        if (this.utils.useStaticModel()) {
            return this.previous.getETag(locale);
        }
        return this.getI18n(locale).eTag();
    }

    public Map<String, String> getTexts(Locale locale) {
        if (this.utils.useStaticModel()) {
            return this.previous.getTexts(locale);
        }
        return this.getI18n(locale).texts();
    }

    private MetaDataAccessor.I18n getI18n(Locale locale) {
        String tenant = RequestContext.getCurrent((CdsRuntime)this.runtime).getUserInfo().getTenant();
        String localeString = locale == null ? "" : LocaleUtils.getLocaleString((Locale)locale);
        return this.accessor.getI18n(ModelId.create((String)tenant).language(localeString).allFeatures().build(), Integer.MAX_VALUE);
    }
}

