/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.ElementAggregator;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.transformation.CqnAggregateTransformation;
import com.sap.cds.ql.impl.transformations.AggregateTrafo;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;

public class AggregateConverter {
    private AggregateConverter() {
    }

    public static CqnAggregateTransformation of(Aggregate agg, ExpressionParser expressionParser) {
        ArrayList<CqnSelectListValue> items = new ArrayList<CqnSelectListValue>();
        ElementAggregator aggregator = new ElementAggregator(expressionParser);
        List agExps = agg.getExpressions();
        for (AggregateExpression agExp : agExps) {
            String alias;
            Value<?> func;
            if (agExp.getInlineAggregateExpression() != null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, agExp.getPath().toArray());
            }
            if (agExp.getExpression() != null) {
                func = aggregator.genericAggregate(agExp.getExpression(), agExp.getStandardMethod());
                alias = agExp.getAlias();
            } else {
                String path = agExp.getPath().stream().map(p -> p.getSegmentValue()).collect(Collectors.joining("."));
                func = aggregator.customAggregate(agExp.getPath());
                alias = path.startsWith("$") ? agExp.getAlias() : path;
            }
            items.add(func.as(alias));
        }
        return AggregateTrafo.aggregate(items);
    }
}

