/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.ApplyHandler;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.transformation.CqnAncestorsTransformation;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.transformations.AncestorsTrafo;
import com.sap.cds.ql.impl.transformations.DescendantsTrafo;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.apply.Ancestors;
import org.apache.olingo.server.api.uri.queryoption.apply.Descendants;
import org.apache.olingo.server.api.uri.queryoption.apply.HierarchicalSubsetTransformation;

public abstract class HierarchySubsetConverter {
    public static CqnAncestorsTransformation ancestors(Ancestors ancestors, ExpressionParser expressionParser) {
        ParamConverter converter = new ParamConverter((HierarchicalSubsetTransformation)ancestors, expressionParser);
        return (CqnAncestorsTransformation)((AncestorsTrafo)((AncestorsTrafo)AncestorsTrafo.ancestors((CqnStructuredTypeRef)converter.hierarchyReference(), (String)converter.hierarchyQualifier(), (CqnElementRef)converter.nodeProperty()).distanceFromStart(converter.distinctFromStart())).keepStart(converter.keepStart())).transformations(converter.transformations());
    }

    public static CqnTransformation descendants(Descendants descendants, ExpressionParser expressionParser) {
        ParamConverter converter = new ParamConverter((HierarchicalSubsetTransformation)descendants, expressionParser);
        return ((DescendantsTrafo)((DescendantsTrafo)DescendantsTrafo.descendants((CqnStructuredTypeRef)converter.hierarchyReference(), (String)converter.hierarchyQualifier(), (CqnElementRef)converter.nodeProperty()).distanceFromStart(converter.distinctFromStart())).keepStart(converter.keepStart())).transformations(converter.transformations());
    }

    private static class ParamConverter {
        private ExpressionParser parser;
        private HierarchicalSubsetTransformation transformation;

        public ParamConverter(HierarchicalSubsetTransformation transformation, ExpressionParser expressionParser) {
            this.transformation = transformation;
            this.parser = expressionParser;
        }

        CqnStructuredTypeRef hierarchyReference() {
            return this.parser.getTargetTypeRef(this.transformation.getHierarchyReference());
        }

        String hierarchyQualifier() {
            return this.transformation.getHierarchyQualifier();
        }

        CqnElementRef nodeProperty() {
            return CQL.get(this.parser.toSegmentList(this.transformation.getNodeProperty()));
        }

        List<CqnTransformation> transformations() {
            List applies = this.transformation.getTransformations();
            ApplyHandler applyHandler = new ApplyHandler(applies, this.parser);
            List<CqnTransformation> transformations = applyHandler.getTransformations(0);
            return transformations;
        }

        int distinctFromStart() {
            return this.transformation.getDistanceFromStart() != null ? this.transformation.getDistanceFromStart() : -1;
        }

        boolean keepStart() {
            return this.transformation.isKeepStart() == Boolean.TRUE;
        }
    }
}

