/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.transformations.OrderByTrafo;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.apply.OrderBy;

public class OrderByConverter {
    private OrderByConverter() {
    }

    public static List<CqnSortSpecification> toSortSpecs(OrderByOption orderBy, ExpressionParser expressionParser) {
        ArrayList<CqnSortSpecification> sortList = new ArrayList<CqnSortSpecification>();
        for (OrderByItem order : orderBy.getOrders()) {
            CqnValue value = expressionParser.parseValue(order.getExpression());
            sortList.add(CQL.sort((CqnValue)value, (CqnSortSpecification.Order)(order.isDescending() ? CqnSortSpecification.Order.DESC : CqnSortSpecification.Order.ASC)));
        }
        return sortList;
    }

    public static CqnTransformation of(OrderBy orderBy, ExpressionParser expressionParser) {
        return OrderByTrafo.orderBy(OrderByConverter.toSortSpecs(orderBy.getOrderByOption(), expressionParser));
    }
}

