/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.AbstractPrimitiveData2Json;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;

public class ObjectArray2Json<T>
extends AbstractPrimitiveData2Json<T, List<Object>> {
    private final String name;

    private ObjectArray2Json(String name, Function<T, List<Object>> valueFunc) {
        super(valueFunc);
        this.name = name;
    }

    public static <T> ObjectArray2Json<T> val(String name, Function<T, List<Object>> valueFunc) {
        return new ObjectArray2Json<T>(name, valueFunc);
    }

    @Override
    protected void write(List<Object> values, JsonGenerator json) throws IOException {
        json.writeFieldName(this.name);
        json.writeStartArray();
        if (values != null) {
            for (Object v : values) {
                if (v != null) {
                    json.writeObject(v);
                    continue;
                }
                json.writeNull();
            }
        }
        json.writeEndArray();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

