/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.sap.cds.adapter.odata.v4.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v4.metadata.provider.OlingoAwareEdmxV4Provider;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;

public class DefaultEdmxProvider
implements OlingoAwareEdmxV4Provider {
    private static final String UNLOCALIZED_BASE_PATH = "edmx/odata/v4";
    private final Map<String, MetadataInfo> metadataInfoMap = new ConcurrentHashMap<String, MetadataInfo>();
    private final CdsRuntime runtime;
    private String basePath = "edmx";

    public DefaultEdmxProvider(CdsRuntime runtime) {
        this.runtime = runtime;
        CdsProperties.ODataV4 config = runtime.getEnvironment().getCdsProperties().getOdataV4();
        if (this.getClass().getClassLoader().getResource(config.getEdmxPath()) != null) {
            this.basePath = config.getEdmxPath();
        } else if (config.getLazyI18n().isEnabled().booleanValue() && this.getClass().getClassLoader().getResource(UNLOCALIZED_BASE_PATH) != null) {
            this.basePath = UNLOCALIZED_BASE_PATH;
        }
    }

    public String getETag(String serviceName) {
        return this.getMetadataInfo(serviceName).getETag();
    }

    public InputStream getEdmx(String serviceName) {
        return this.getMetadataInfo(serviceName).getEdmx();
    }

    @Override
    public CsdlEdmProvider getEdmProvider(String serviceName) {
        return this.getMetadataInfo(serviceName).getEdmProvider();
    }

    MetadataInfo getMetadataInfo(String serviceName) {
        Locale locale = RequestContext.getCurrent((CdsRuntime)this.runtime).getParameterInfo().getLocale();
        MetadataInfo info = this.getMetadataInfo(serviceName, locale);
        if (locale != null && info.isEmpty()) {
            info = this.getMetadataInfo(serviceName, null);
        }
        if (info.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA, new Object[]{serviceName});
        }
        return info;
    }

    private MetadataInfo getMetadataInfo(String unlocalizedServiceName, Locale locale) {
        Object serviceName;
        if (locale != null) {
            String language = LocaleUtils.getLocaleForBundle((Locale)locale).toString();
            serviceName = unlocalizedServiceName + "_" + language;
        } else {
            serviceName = unlocalizedServiceName;
        }
        return this.metadataInfoMap.computeIfAbsent((String)serviceName, arg_0 -> this.lambda$getMetadataInfo$0((String)serviceName, arg_0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ MetadataInfo lambda$getMetadataInfo$0(String serviceName, String key) {
        try {
            String resourcePathToEdmx = this.basePath + "/" + serviceName + ".xml";
            try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream(resourcePathToEdmx);){
                if (resource == null) return MetadataInfo.create(serviceName, null, this.runtime);
                MetadataInfo metadataInfo = MetadataInfo.create(serviceName, resource.readAllBytes(), this.runtime);
                return metadataInfo;
            }
        }
        catch (Exception e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA, new Object[]{serviceName, e});
        }
    }
}

