/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils.mapper;

import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class V4EdmxFlavourMapper
implements EdmxFlavourMapper {
    private final boolean toCsn;

    public V4EdmxFlavourMapper(boolean toCsn) {
        this.toCsn = toCsn;
    }

    @Override
    public String remap(String element, CdsStructuredType type) {
        return this.createMappings(type, true, false).filter(m -> this.toCsn ? m.getEdmxName().equals(element) : m.getCsnName().equals(element)).map(m -> this.toCsn ? m.getCsnName() : m.getEdmxName()).findAny().orElse(element);
    }

    @Override
    public <T extends Iterable<? extends Map<String, Object>>> T remap(T entries, CdsStructuredType entryType, final Function<String, Boolean> isExpanded) {
        DataProcessor.create().withDepthFirst().action(new DataProcessor.Action(){

            public void entries(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> data) {
                V4EdmxFlavourMapper.this.remap(path, element, type, data, isExpanded);
            }
        }).process(entries, entryType);
        return entries;
    }

    private void remap(Path path, CdsElement element, CdsStructuredType type, Iterable<Map<String, Object>> data, Function<String, Boolean> isExpanded) {
        boolean insideArray = Stream.concat(StreamSupport.stream(path.spliterator(), false).map(p -> p.element()), Stream.of(element)).filter(Objects::nonNull).anyMatch(e -> e.getType().isArrayed());
        boolean entityRoot = (path.iterator().hasNext() ? path.root().type() : type) instanceof CdsEntity;
        List<MappingV4> mappings = this.createMappings(type, !insideArray && entityRoot, false).sorted((m1, m2) -> Boolean.compare(m1.isForeignKey, m2.isForeignKey)).collect(Collectors.toList());
        for (Map<String, Object> map : data) {
            for (MappingV4 mapping : mappings) {
                if (this.toCsn) {
                    if (!map.containsKey(mapping.getEdmxName())) continue;
                    Object value = map.remove(mapping.getEdmxName());
                    if (DataUtils.containsKey(map, (String)mapping.getCsnName(), (boolean)true)) continue;
                    DataUtils.putPath(map, (String)mapping.getCsnName(), (Object)value);
                    continue;
                }
                String nextLevelCsnName = mapping.element.getName() + "." + mapping.innerMapping.getEdmxName();
                if (!DataUtils.containsKey(map, (String)nextLevelCsnName)) continue;
                Object value = DataUtils.getOrDefault(map, (String)nextLevelCsnName, null);
                boolean expanded = isExpanded.apply(this.join(path, element, mapping.element));
                if (!mapping.isForeignKey || !expanded && this.containsOnlyFKs(mapping, mappings, map)) {
                    this.removeDeep(map, nextLevelCsnName);
                }
                map.put(mapping.getEdmxName(), value);
            }
        }
    }

    public Stream<MappingV4> createMappings(CdsStructuredType type) {
        return this.createMappings(type, type.getKind() == CdsKind.ENTITY, true);
    }

    private Stream<MappingV4> createMappings(CdsStructuredType type, boolean flattenStructs, boolean includeUnmapped) {
        return this.createMappings(type, flattenStructs, false, false, includeUnmapped).filter(m -> includeUnmapped || !Objects.equals(m.getEdmxName(), m.getCsnName()));
    }

    private Stream<MappingV4> createMappings(CdsStructuredType type, boolean flattenStructs, boolean isForeignKey, boolean insideStruct, boolean includeUnmapped) {
        return type.elements().flatMap(e -> this.createMappings((CdsElement)e, flattenStructs, isForeignKey, insideStruct, includeUnmapped));
    }

    private Stream<MappingV4> createMappings(CdsElement element, boolean flattenStructs, boolean isForeignKey, boolean insideStruct, boolean includeUnmapped) {
        CdsType type = element.getType();
        if (type.isStructured()) {
            if (includeUnmapped && !flattenStructs) {
                return Stream.of(new MappingV4(element, false));
            }
            return this.createMappings((CdsStructuredType)type.as(CdsStructuredType.class), flattenStructs, isForeignKey, true, false).map(i -> new MappingV4(element, false, (EdmxFlavourMapper.Mapping)i));
        }
        if (type.isAssociation()) {
            Stream<MappingV4> mappings = AssociationAnalyzer.refElements((CdsElement)element).flatMap(k -> this.createMappings((CdsElement)k, flattenStructs, true, false, includeUnmapped)).map(i -> new MappingV4(element, true, (EdmxFlavourMapper.Mapping)i));
            if (includeUnmapped && !isForeignKey || flattenStructs && insideStruct) {
                return Stream.concat(Stream.of(new MappingV4(element, false)), mappings);
            }
            return mappings;
        }
        if (includeUnmapped || flattenStructs || isForeignKey) {
            return Stream.of(new MappingV4(element, isForeignKey));
        }
        return Stream.empty();
    }

    private String join(Path path, CdsElement parent, CdsElement element) {
        ArrayList<String> segments = new ArrayList<String>();
        path.iterator().forEachRemaining(s -> {
            if (s.element() != null) {
                segments.add(s.segment().id());
            }
        });
        if (parent != null) {
            segments.add(parent.getName());
        }
        segments.add(element.getName());
        return String.join((CharSequence)".", segments);
    }

    private boolean containsOnlyFKs(MappingV4 current, List<MappingV4> others, Map<String, Object> map) {
        Object assoc;
        if (current.isForeignKey && current.element.getType().isAssociation() && (assoc = map.get(current.element.getName())) instanceof Map) {
            Map map1 = (Map)assoc;
            List fks = others.stream().filter(o -> o.element.getName().equals(current.element.getName())).map(o -> o.innerMapping.getEdmxName()).collect(Collectors.toList());
            return fks.containsAll(map1.keySet());
        }
        return false;
    }

    private void removeDeep(Map<String, Object> data, String path) {
        int lastDot = path.lastIndexOf(".");
        if (lastDot > 0) {
            String start = path.substring(0, lastDot);
            String end = path.substring(lastDot + 1);
            Map last = (Map)DataUtils.getOrDefault(data, (String)start, null);
            if (last != null) {
                last.remove(end);
                if (last.isEmpty()) {
                    this.removeDeep(data, start);
                }
            }
        } else {
            data.remove(path);
        }
    }

    private class MappingV4
    implements EdmxFlavourMapper.Mapping {
        private final CdsElement element;
        private final boolean isForeignKey;
        private final EdmxFlavourMapper.Mapping innerMapping;

        public MappingV4(CdsElement element, boolean isForeignKey) {
            this(element, isForeignKey, null);
        }

        public MappingV4(CdsElement element, boolean isForeignKey, EdmxFlavourMapper.Mapping innerMapping) {
            this.element = element;
            this.isForeignKey = isForeignKey;
            this.innerMapping = innerMapping;
        }

        @Override
        public CdsElement getTargetElement() {
            return this.innerMapping == null ? this.element : this.innerMapping.getTargetElement();
        }

        @Override
        public CdsElement getRootElement() {
            return this.element;
        }

        @Override
        public String getEdmxName() {
            return this.innerMapping == null ? this.element.getName() : this.element.getName() + "_" + this.innerMapping.getEdmxName();
        }

        @Override
        public String getCsnName() {
            return this.innerMapping == null ? this.element.getName() : this.element.getName() + "." + this.innerMapping.getCsnName();
        }
    }
}

