/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.preview;

import com.sap.cds.adapter.odata.v4.ODataV4IndexContentProvider;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.path.CdsServicePath;
import com.sap.cds.services.utils.path.UrlPathUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

class CdsFioriPreviewServlet
extends HttpServlet {
    private static final String COMPONENT_JS = "/app/Component.js";
    private static final String MANIFEST_JSON = "/app/manifest.json";
    private static final String FIORI_PATH = "/%s/%s";
    private static final String ROUTE_TEMPLATE = ",\n\t\t\t\t{\n\t\t\t\t\t\"name\": \"${navProperty}Route\",\n\t\t\t\t\t\"target\": \"${navProperty}Target\",\n\t\t\t\t\t\"pattern\": \"${entityName}({key})/${navProperty}({key2}):?query:\"\n\t\t\t\t}";
    private static final String TARGET_TEMPLATE = ",\n\t\t\t\t\"${navProperty}Target\": {\n\t\t\t\t\t\"type\": \"Component\",\n\t\t\t\t\t\"id\": \"${navProperty}Target\",\n\t\t\t\t\t\"name\": \"sap.fe.templates.ObjectPage\",\n\t\t\t\t\t\"options\": {\n\t\t\t\t\t\t\"settings\": {\n\t\t\t\t\t\t\t\"entitySet\": \"${targetEntity}\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}";
    private static final String OPTIONS_TEMPLATE = "\n\t\t\t\t\t\t\t\t\"${navProperty}\": {\n\t\t\t\t\t\t\t\t\t\"detail\": {\n\t\t\t\t\t\t\t\t\t\t\"route\": \"${navProperty}Route\"\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},";
    private final CdsRuntime runtime;
    private final List<FioriPreview> previews;
    private final String ui5;

    CdsFioriPreviewServlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.previews = CdsFioriPreviewServlet.findFioriPreviews(runtime);
        CdsProperties.ODataV4.FioriPreview.UI5 config = runtime.getEnvironment().getCdsProperties().getOdataV4().getFioriPreview().getUi5();
        this.ui5 = config.getHost() + (String)(config.getVersion() != null ? "/" + config.getVersion() : "");
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String page;
        String contentType;
        String contextPath;
        String pathInfo = req.getPathInfo();
        FioriPreview preview = this.previews.stream().filter(p -> pathInfo.equals(p.fioriPath) || pathInfo.equals(p.fioriPath + COMPONENT_JS) || pathInfo.equals(p.fioriPath + MANIFEST_JSON)).findFirst().orElse(null);
        if (preview == null || !req.getMethod().equals("GET")) {
            resp.setStatus(404);
            return;
        }
        String string = contextPath = this.getServletConfig() == null ? req.getContextPath() : this.getServletConfig().getServletContext().getContextPath();
        if (pathInfo.equals(preview.fioriPath)) {
            contentType = "text/html;charset=UTF-8";
            page = this.resource("index.html").replace("${ui5}", this.ui5).replace("${serviceName}", preview.serviceName).replace("${entityName}", preview.entityName).replace("${componentPath}", contextPath + "/$fiori-preview" + preview.fioriPath + "/app");
        } else if (pathInfo.equals(preview.fioriPath + MANIFEST_JSON)) {
            contentType = "application/json;charset=UTF-8";
            page = this.resource("manifest.json").replace("${serviceName}", preview.serviceName).replace("${entityName}", preview.entityName).replace("${servicePath}", this.odataServicePath(preview.servicePath, contextPath));
            Object navRoutes = "";
            Object navTargets = "";
            Object navOptions = "";
            for (CdsElement assoc : preview.entity.associations().filter(this::isExposedAssociation).toList()) {
                String navProperty = assoc.getName();
                String targetEntity = ODataUtils.toODataName((String)((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).getTarget().getName());
                navRoutes = (String)navRoutes + ROUTE_TEMPLATE.replace("${navProperty}", navProperty).replace("${entityName}", preview.entityName);
                navTargets = (String)navTargets + TARGET_TEMPLATE.replace("${navProperty}", navProperty).replace("${targetEntity}", targetEntity);
                navOptions = (String)navOptions + OPTIONS_TEMPLATE.replace("${navProperty}", navProperty);
            }
            navOptions = !((String)navOptions).isEmpty() ? ((String)navOptions).substring(0, ((String)navOptions).length() - 1) : navOptions;
            page = page.replace("${navRoutes}", (CharSequence)navRoutes).replace("${navTargets}", (CharSequence)navTargets).replace("${navOptions}", (CharSequence)navOptions);
        } else {
            contentType = "text/javascript;charset=UTF-8";
            page = this.resource("Component.js");
        }
        resp.setStatus(200);
        resp.setContentType(contentType);
        resp.getWriter().write(page);
    }

    private String odataServicePath(String servicePath, String contextPath) {
        String basePath = UrlPathUtil.normalizeBasePath((String)this.runtime.getEnvironment().getCdsProperties().getOdataV4().getEndpoint().getPath());
        String theBasePath = contextPath + (basePath.equals("/") ? "" : basePath);
        return theBasePath + "/" + servicePath;
    }

    private String resource(String file) {
        try {
            return new String(CdsFioriPreviewServlet.class.getClassLoader().getResourceAsStream("com.sap.cds/fiori-preview/" + file).readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[]{e});
        }
    }

    private boolean isExposedAssociation(CdsElement e) {
        String target = ((CdsAssociationType)e.getType().as(CdsAssociationType.class)).getTarget().getQualifiedName();
        return !e.getName().equals("SiblingEntity") && !target.endsWith(".texts") && !target.endsWith("_texts") && !target.endsWith("DraftAdministrativeData");
    }

    private static List<FioriPreview> findFioriPreviews(CdsRuntime runtime) {
        ArrayList<FioriPreview> previews = new ArrayList<FioriPreview>();
        Stream cdsServicePaths = CdsServicePath.servicePaths((CdsRuntime)runtime, (String)"odata-v4");
        cdsServicePaths.filter(p -> p.getCdsDefinition() instanceof CdsService).forEach(s -> {
            String serviceName = s.getCdsDefinition().getQualifiedName();
            String servicePath = s.getPath();
            s.subPaths().filter(e -> ODataV4IndexContentProvider.isExposedEntity(e.getCdsDefinition())).forEach(e -> {
                String entityName = ODataUtils.toODataName((String)e.getPath());
                previews.add(new FioriPreview(serviceName, entityName, (CdsEntity)e.getCdsDefinition().as(CdsEntity.class), servicePath, FIORI_PATH.formatted(serviceName, entityName)));
            });
        });
        return previews;
    }

    record FioriPreview(String serviceName, String entityName, CdsEntity entity, String servicePath, String fioriPath) {
    }
}

