/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.AggregateConverter;
import com.sap.cds.adapter.odata.v4.query.apply.ComputeConverter;
import com.sap.cds.adapter.odata.v4.query.apply.CustomConverter;
import com.sap.cds.adapter.odata.v4.query.apply.FilterConverter;
import com.sap.cds.adapter.odata.v4.query.apply.GroupByConverter;
import com.sap.cds.adapter.odata.v4.query.apply.HierarchySubsetConverter;
import com.sap.cds.adapter.odata.v4.query.apply.LimitConverter;
import com.sap.cds.adapter.odata.v4.query.apply.OrderByConverter;
import com.sap.cds.adapter.odata.v4.query.apply.SearchConverter;
import com.sap.cds.adapter.odata.v4.query.apply.TopLevelsConverter;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.Ancestors;
import org.apache.olingo.server.api.uri.queryoption.apply.Compute;
import org.apache.olingo.server.api.uri.queryoption.apply.Concat;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;
import org.apache.olingo.server.api.uri.queryoption.apply.Descendants;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.OrderBy;
import org.apache.olingo.server.api.uri.queryoption.apply.Search;
import org.apache.olingo.server.api.uri.queryoption.apply.Skip;
import org.apache.olingo.server.api.uri.queryoption.apply.Top;

public class ApplyConverter {
    private ExpressionParser expressionParser;

    public ApplyConverter(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public List<List<CqnTransformation>> unfoldAndConvert(List<ApplyItem> items) {
        ApplyItem last;
        int n = items.size();
        if (n > 0 && (last = items.get(n - 1)).getKind() == ApplyItem.Kind.CONCAT) {
            List<ApplyItem> stem = items.subList(0, n - 1);
            return this.unfoldConcats(stem, (Concat)last);
        }
        return List.of(items.stream().map(this::transformation).toList());
    }

    private List<List<CqnTransformation>> unfoldConcats(List<ApplyItem> stem, Concat concat) {
        List concats = concat.getApplyOptions();
        int m = concats.size();
        ArrayList<List<CqnTransformation>> all = new ArrayList<List<CqnTransformation>>(m);
        for (int i = 0; i < m; ++i) {
            ArrayList<ApplyItem> unfolded = new ArrayList<ApplyItem>(stem);
            List concatItems = ((ApplyOption)concats.get(i)).getApplyItems();
            unfolded.addAll(concatItems);
            all.addAll(this.unfoldAndConvert(unfolded));
        }
        return all;
    }

    private CqnTransformation transformation(ApplyItem applyItem) {
        ApplyItem.Kind kind = applyItem.getKind();
        switch (kind) {
            case IDENTITY: {
                return CqnTransformation.IDENTITY;
            }
            case AGGREGATE: {
                return AggregateConverter.of((Aggregate)applyItem, this.expressionParser);
            }
            case GROUP_BY: {
                return GroupByConverter.of((GroupBy)applyItem, this.expressionParser);
            }
            case ORDERBY: {
                return OrderByConverter.of((OrderBy)applyItem, this.expressionParser);
            }
            case TOP: {
                return LimitConverter.top((Top)applyItem);
            }
            case SKIP: {
                return LimitConverter.skip((Skip)applyItem);
            }
            case SEARCH: {
                return SearchConverter.of((Search)applyItem);
            }
            case FILTER: {
                return FilterConverter.of((Filter)applyItem, this.expressionParser);
            }
            case COMPUTE: {
                return ComputeConverter.of((Compute)applyItem, this.expressionParser);
            }
            case CUSTOM_FUNCTION: {
                CustomFunction function = (CustomFunction)applyItem;
                if (TopLevelsConverter.handles(function)) {
                    return TopLevelsConverter.of(function, this.expressionParser);
                }
                return new CustomConverter((CustomFunction)applyItem, this.expressionParser);
            }
            case ANCESTORS: {
                return HierarchySubsetConverter.ancestors((Ancestors)applyItem, this.expressionParser);
            }
            case DESCENDANTS: {
                return HierarchySubsetConverter.descendants((Descendants)applyItem, this.expressionParser);
            }
            case CONCAT: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_CONCAT_LAST, new Object[]{kind.name()});
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, new Object[]{kind.name()});
    }
}

