/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.transformation.CqnCustomTransformation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;

public class CustomConverter
implements CqnCustomTransformation {
    private final String name;
    private final Map<String, CqnToken> parameters;

    public CustomConverter(CustomFunction customFunction, ExpressionParser expressionParser) {
        this.name = customFunction.getFunction().getFullQualifiedName().getFullQualifiedNameAsString();
        this.parameters = new ParamConverter(expressionParser).convert(customFunction.getParameters());
    }

    public String name() {
        return this.name;
    }

    public Map<String, CqnToken> parameters() {
        return this.parameters;
    }

    private static class ParamConverter {
        private final ExpressionParser parser;

        public ParamConverter(ExpressionParser expressionParser) {
            this.parser = expressionParser;
        }

        public Map<String, CqnToken> convert(List<UriParameter> parameters) {
            return parameters.stream().collect(Collectors.toMap(UriParameter::getName, this::convertParam));
        }

        private CqnToken convertParam(UriParameter p) {
            Expression expr = p.getExpression();
            if (expr != null) {
                return this.parser.parseToken(expr);
            }
            return CQL.val((Object)p.getText());
        }
    }
}

