/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.transformation.CqnTopLevelsTransformation;
import com.sap.cds.ql.impl.transformations.TopLevelsTrafo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.queryoption.apply.CustomFunction;

public class TopLevelsConverter {
    private static final String NAME = "com.sap.vocabularies.Hierarchy.v1.TopLevels";

    private TopLevelsConverter() {
    }

    public static CqnTopLevelsTransformation of(CustomFunction custom, ExpressionParser expressionParser) {
        ParamConverter converter = new ParamConverter(custom, expressionParser);
        return (CqnTopLevelsTransformation)TopLevelsTrafo.topLevels((long)converter.levels(), converter.expandLevels()).hierarchy(converter.hierarchyReference(), converter.hierarchyQualifier(), converter.nodeProperty());
    }

    private static String unquote(String text) {
        if (text.startsWith("'")) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static boolean handles(CustomFunction function) {
        return NAME.equals(function.getFunction().getFullQualifiedName().getFullQualifiedNameAsString());
    }

    private static class ParamConverter {
        private final ExpressionParser parser;
        private final Map<String, UriParameter> params;
        private static final ObjectMapper mapper = new ObjectMapper();

        public ParamConverter(CustomFunction transformation, ExpressionParser expressionParser) {
            this.params = transformation.getParameters().stream().collect(Collectors.toMap(UriParameter::getName, p -> p));
            this.parser = expressionParser;
        }

        CqnStructuredTypeRef hierarchyReference() {
            UriParameter ref = this.params.get("HierarchyNodes");
            return this.parser.getTargetTypeRef(ref.getExpression());
        }

        String hierarchyQualifier() {
            return TopLevelsConverter.unquote(this.params.get("HierarchyQualifier").getText());
        }

        CqnElementRef nodeProperty() {
            UriParameter node = this.params.get("NodeProperty");
            return CQL.get((String)node.getText());
        }

        Map<Object, Long> expandLevels() {
            List deserialized;
            String key = "ExpandLevels";
            if (!this.params.containsKey(key)) {
                return Map.of();
            }
            UriParameter node = this.params.get(key);
            String jsonArray = node.getText();
            try {
                deserialized = (List)mapper.readValue(jsonArray, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            }
            catch (JsonProcessingException e) {
                return Map.of();
            }
            return deserialized.stream().collect(Collectors.toMap(m -> m.get("NodeID"), m -> ((Number)m.get("Levels")).longValue()));
        }

        long levels() {
            return this.params.containsKey("Levels") ? Long.parseLong(this.params.get("Levels").getText()) : -1L;
        }
    }
}

