/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public class ElementUtils {
    public static StructuredType<?> aliasedTo(String path) {
        if (path.contains(".")) {
            return CQL.to((String)path).as(path);
        }
        return CQL.to((String)path);
    }

    public static CqnSelectListValue aliasedGet(String path) {
        if (path.contains(".")) {
            return CQL.get((String)path).as(path);
        }
        return CQL.get((String)path);
    }

    public static Map<String, CdsElement> recursiveElements(CdsStructuredType type) {
        return ElementUtils.recursiveElements(type, e -> true);
    }

    public static Map<String, CdsElement> recursiveElements(CdsStructuredType type, Predicate<? super CdsElement> filter) {
        LinkedHashMap<String, CdsElement> elements = new LinkedHashMap<String, CdsElement>();
        type.elements().forEach(e -> ElementUtils.collectElements(elements, null, e, filter));
        return elements;
    }

    private static void collectElements(Map<String, CdsElement> elements, String path, CdsElement element, Predicate<? super CdsElement> filter) {
        if (element.getType().isStructured()) {
            String elementPath = ElementUtils.join(path, element.getName());
            ((CdsStructuredType)element.getType().as(CdsStructuredType.class)).elements().forEach(e -> ElementUtils.collectElements(elements, elementPath, e, filter));
        } else if (filter.test((CdsElement)element)) {
            String elementPath = ElementUtils.join(path, element.getName());
            elements.put(elementPath, element);
        }
    }

    private static String join(String path, String id) {
        if (StringUtils.isEmpty((String)path)) {
            return id;
        }
        return path + "." + id;
    }
}

