/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnNullValue;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessagesUtils.class);
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String NUMERIC_SEVERITY = "numericSeverity";
    private static final String TARGET = "target";
    private static final String LONG_TEXT_URL = "longtextUrl";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSapMessagesHeader(String bindingParameter, Messages messages) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonFactoryBuilder builder = new JsonFactoryBuilder().configure(JsonWriteFeature.ESCAPE_NON_ASCII, true);
        try (JsonGenerator json = new JsonFactory(builder).createGenerator((OutputStream)outputStream);){
            boolean isFirst = true;
            Iterator iterator = messages.stream().iterator();
            while (iterator.hasNext()) {
                if (isFirst) {
                    json.writeStartArray();
                    isFirst = false;
                }
                Message message = (Message)iterator.next();
                json.writeStartObject();
                json.writeStringField(CODE, MessagesUtils.getMessageCode(message));
                json.writeStringField(MESSAGE, message.getMessage());
                json.writeNumberField(NUMERIC_SEVERITY, message.getSeverity().getNumericSeverity());
                String target = MessagesUtils.getTarget(bindingParameter, message.getTarget());
                if (target != null) {
                    json.writeStringField(TARGET, target);
                }
                if (!StringUtils.isEmpty((String)message.getLongTextUrl())) {
                    json.writeStringField(LONG_TEXT_URL, message.getLongTextUrl());
                }
                json.writeEndObject();
            }
            if (!isFirst) {
                json.writeEndArray();
            }
            json.close();
            if (outputStream.size() == 0) return null;
            String string = outputStream.toString("UTF-8");
            return string;
        }
        catch (IOException e) {
            logger.error("Failed to create sap messages header", (Throwable)e);
        }
        return null;
    }

    public static String getMessageCode(Message message) {
        return StringUtils.isEmpty((String)message.getCode()) ? "<none>" : message.getCode();
    }

    public static String getTarget(String bindingParameter, MessageTarget messageTarget) {
        List segments;
        if (messageTarget == null) {
            return null;
        }
        List list = segments = messageTarget.getRef() == null ? Collections.emptyList() : messageTarget.getRef().segments();
        if (segments.isEmpty()) {
            return messageTarget.getParameter();
        }
        String prefix = "cqn".equals(messageTarget.getParameter()) ? bindingParameter : messageTarget.getParameter();
        final StringBuilder target = new StringBuilder(StringUtils.isEmpty((String)prefix) ? "" : prefix);
        if (!segments.isEmpty() && target.length() > 0 && target.charAt(target.length() - 1) != '/') {
            target.append("/");
        }
        for (CqnReference.Segment segment : segments) {
            target.append(segment.id());
            if (segment.filter().isPresent()) {
                target.append("(");
                final AtomicInteger beforeIsActiveEntityPosition = new AtomicInteger(-1);
                ((CqnPredicate)segment.filter().get()).accept(new CqnVisitor(){

                    public void visit(CqnComparisonPredicate predicate) {
                        if (predicate.operator() == CqnComparisonPredicate.Operator.EQ || predicate.operator() == CqnComparisonPredicate.Operator.IS) {
                            CqnValue left = predicate.left();
                            CqnValue right = predicate.right();
                            CqnValue value = null;
                            String key = null;
                            if (left instanceof CqnElementRef) {
                                CqnElementRef ref = (CqnElementRef)left;
                                key = ref.firstSegment();
                                value = right;
                            } else if (right instanceof CqnElementRef) {
                                CqnElementRef ref = (CqnElementRef)right;
                                key = ref.firstSegment();
                                value = left;
                            }
                            if (key != null) {
                                Object theValue = null;
                                if (value instanceof CqnLiteral) {
                                    String string;
                                    CqnLiteral literal = (CqnLiteral)value;
                                    theValue = literal.value();
                                    if (theValue instanceof String && !MessagesUtils.isUUID(string = (String)theValue)) {
                                        theValue = "'" + theValue + "'";
                                    }
                                } else if (value instanceof CqnNullValue) {
                                    theValue = "null";
                                } else if (value instanceof CqnPlain) {
                                    CqnPlain plain = (CqnPlain)value;
                                    theValue = plain.plain();
                                }
                                if (theValue != null) {
                                    String toAppend = key + "=" + theValue + ",";
                                    int insertAt = beforeIsActiveEntityPosition.get();
                                    if (insertAt > -1) {
                                        target.insert(insertAt, toAppend);
                                        beforeIsActiveEntityPosition.set(insertAt + toAppend.length());
                                    } else {
                                        if (key.equals("IsActiveEntity")) {
                                            beforeIsActiveEntityPosition.set(target.length());
                                        }
                                        target.append(toAppend);
                                    }
                                }
                            }
                        }
                    }
                });
                target.deleteCharAt(target.length() - 1);
                target.append(")");
            }
            target.append("/");
        }
        if (!segments.isEmpty()) {
            target.deleteCharAt(target.length() - 1);
        }
        return target.toString();
    }

    private static boolean isUUID(String s) {
        try {
            UUID.fromString(s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

