/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.cds;

import com.sap.cds.adapter.odata.v4.metadata.cds.CdsServiceEdmUtils;
import com.sap.cds.adapter.odata.v4.utils.ElementUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsBoundAction;
import com.sap.cds.reflect.CdsBoundFunction;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlNamed;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;

class CdsServiceEdmSchema
extends CsdlSchema {
    private final CdsService service;
    private final EdmxFlavourMapper.EdmxFlavour flavour;
    private final EdmxFlavourMapper flavourMapper;
    private final Map<String, CdsEntityInfo> entityLookup = new HashMap<String, CdsEntityInfo>();
    private final Map<String, List<CdsOperationInfo<CdsAction>>> actionLookup = new HashMap<String, List<CdsOperationInfo<CdsAction>>>();
    private final Map<String, List<CdsOperationInfo<CdsFunction>>> functionLookup = new HashMap<String, List<CdsOperationInfo<CdsFunction>>>();
    private final Map<String, CdsStructuredTypeInfo> complexTypeLookup = new HashMap<String, CdsStructuredTypeInfo>();
    private final Map<CdsDefinition, CsdlNamed> cached = new HashMap<CdsDefinition, CsdlNamed>();
    private static final Set<String> MAX_LENGTH_FACET_TYPES = Set.of("Edm.String", "Edm.Stream", "Edm.Binary");
    private static final Set<String> PRECISION_FACET_TYPES = Set.of("Edm.Decimal", "Edm.DateTimeOffset", "Edm.Duration", "Edm.TimeOfDay");
    private static final Set<String> SRID_FACET_TYPES = Set.of("Edm.Geography", "Edm.GeographyPoint", "Edm.GeographyLineString", "Edm.GeographyPolygon", "Edm.GeographyMultiPoint", "Edm.GeographyMultiLineString", "Edm.GeographyMultiPolygon", "Edm.GeographyCollection", "Edm.Geometry", "Edm.GeometryPoint", "Edm.GeometryLineString", "Edm.GeometryPolygon", "Edm.GeometryMultiPoint", "Edm.GeometryMultiLineString", "Edm.GeometryMultiPolygon", "Edm.GeometryCollection");
    private static final Set<String> ALL_TYPES = Stream.of(MAX_LENGTH_FACET_TYPES, PRECISION_FACET_TYPES, SRID_FACET_TYPES, Set.of("Edm.Boolean", "Edm.Byte", "Edm.Double", "Edm.Guid", "Edm.Int16", "Edm.Int32", "Edm.Int64", "Edm.SByte", "Edm.Single")).flatMap(Collection::stream).collect(Collectors.toSet());

    CdsServiceEdmSchema(CdsService service, CsdlEntityContainer entityContainer, EdmxFlavourMapper.EdmxFlavour flavour, EdmxFlavourMapper flavourMapper) {
        this.service = service;
        this.flavour = flavour;
        this.flavourMapper = flavourMapper;
        service.entities().filter(CdsServiceEdmUtils::isIncluded).forEach(e -> {
            if (CdsServiceEdmUtils.isParameterized(e)) {
                this.entityLookup.put(CdsServiceEdmUtils.name((CdsDefinition)e) + "Parameters", new CdsEntityInfo((CdsEntity)e, EntityTypeKind.PARAMETERIZED_PARAMETERS));
                this.entityLookup.put(CdsServiceEdmUtils.name((CdsDefinition)e) + "Type", new CdsEntityInfo((CdsEntity)e, EntityTypeKind.PARAMETERIZED_TYPE));
            } else {
                this.entityLookup.put(CdsServiceEdmUtils.name((CdsDefinition)e), new CdsEntityInfo((CdsEntity)e, EntityTypeKind.DEFAULT));
            }
            e.actions().forEach(a -> this.actionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)a), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsAction>((CdsAction)a, (CdsEntity)e))));
            e.functions().forEach(f -> this.functionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)f), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsFunction>((CdsFunction)f, (CdsEntity)e))));
        });
        service.actions().forEach(a -> this.actionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)a), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsAction>((CdsAction)a, null))));
        service.functions().forEach(f -> this.functionLookup.compute(CdsServiceEdmUtils.name((CdsDefinition)f), (k, v) -> CdsServiceEdmSchema.addOrInit(v, new CdsOperationInfo<CdsFunction>((CdsFunction)f, null))));
        this.setNamespace(service.getQualifiedName());
        this.setEntityContainer(entityContainer);
        this.setEntityTypes(null);
        this.setComplexTypes(null);
        this.setActions(null);
        this.setFunctions(null);
    }

    public CsdlEntityType getEntityType(String name) {
        CdsEntityInfo info = this.entityLookup.get(name);
        if (info != null) {
            return this.buildEntityType(info);
        }
        return null;
    }

    public List<CsdlEntityType> getEntityTypes() {
        return this.entityLookup.values().stream().map(this::buildEntityType).toList();
    }

    private CsdlEntityType buildEntityType(CdsEntityInfo info) {
        CdsEntity entity = info.entity();
        EntityTypeKind kind = info.kind();
        Function<CdsDefinition, CsdlNamed> builder = e -> {
            CsdlEntityType entityType = new CsdlEntityType();
            entityType.setKey(new ArrayList());
            if (kind == EntityTypeKind.DEFAULT || kind == EntityTypeKind.PARAMETERIZED_TYPE) {
                entityType.setName(CdsServiceEdmUtils.name((CdsDefinition)entity) + (kind == EntityTypeKind.PARAMETERIZED_TYPE ? "Type" : ""));
                entityType.setOpenType(((Boolean)entity.getAnnotationValue("open", (Object)false)).booleanValue());
                this.flavourMapper.createMappings((CdsStructuredType)entity).forEach(mapped -> {
                    if (mapped.getTargetElement().getType().isAssociation()) {
                        entityType.getNavigationProperties().add(this.createNavigationProperty((EdmxFlavourMapper.Mapping)mapped, (CdsStructuredType)entity, false));
                        if (this.flavour == EdmxFlavourMapper.EdmxFlavour.X4 && mapped.getRootElement().isKey()) {
                            this.addKeyPaths(mapped.getRootElement(), entityType);
                        }
                    } else if (CdsServiceEdmUtils.isIncluded(mapped.getTargetElement())) {
                        entityType.getProperties().add(this.createProperty((EdmxFlavourMapper.Mapping)mapped, entityType.getName(), false));
                        if (mapped.getRootElement().isKey()) {
                            if (this.flavour == EdmxFlavourMapper.EdmxFlavour.X4) {
                                this.addKeyPaths(mapped.getRootElement(), entityType);
                            } else {
                                entityType.getKey().add(new CsdlPropertyRef().setName(mapped.getEdmxName()));
                            }
                        }
                    }
                });
                if (kind == EntityTypeKind.PARAMETERIZED_TYPE) {
                    CsdlNavigationProperty parametersNavigation = new CsdlNavigationProperty();
                    parametersNavigation.setName("Parameters");
                    parametersNavigation.setType(CdsServiceEdmUtils.fqn((CdsDefinition)entity) + "Parameters");
                    entityType.getNavigationProperties().add(parametersNavigation);
                }
            } else {
                entityType.setName(CdsServiceEdmUtils.name((CdsDefinition)entity) + "Parameters");
                entity.params().forEach(parameter -> {
                    entityType.getKey().add(new CsdlPropertyRef().setName(parameter.getName()));
                    CsdlProperty property = new CsdlProperty();
                    property.setName(parameter.getName());
                    property.setType(this.type(parameter.getType(), (CdsAnnotatable)parameter, CdsServiceEdmUtils::name));
                    property.setCollection(parameter.getType().isArrayed());
                    property.setNullable(false);
                    if (parameter.getType().isSimple()) {
                        SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)parameter.getType().as(CdsSimpleType.class), property.getType(), (CdsAnnotatable)parameter);
                        property.setMaxLength(properties.maxLength());
                        property.setPrecision(properties.precision());
                        property.setScale(properties.scale());
                        property.setScaleAsString(properties.scaleAsString());
                        property.setSrid(properties.srid());
                    }
                    entityType.getProperties().add(property);
                });
                CsdlNavigationProperty parametersNavigation = new CsdlNavigationProperty();
                parametersNavigation.setName("Set");
                parametersNavigation.setType(CdsServiceEdmUtils.fqn((CdsDefinition)entity) + "Type");
                parametersNavigation.setCollection(true);
                parametersNavigation.setContainsTarget(true);
                entityType.getNavigationProperties().add(parametersNavigation);
            }
            if (entityType.getKey().isEmpty()) {
                entityType.setKey(null);
            }
            return entityType;
        };
        if (kind == EntityTypeKind.DEFAULT) {
            return (CsdlEntityType)this.cached.computeIfAbsent((CdsDefinition)entity, builder);
        }
        return (CsdlEntityType)builder.apply((CdsDefinition)entity);
    }

    public CsdlComplexType getComplexType(String name) {
        CdsStructuredTypeInfo structuredTypeInfo = this.complexTypeLookup.get(name);
        if (structuredTypeInfo != null) {
            return this.buildComplexType(name, structuredTypeInfo);
        }
        if ("cds_Map".equals(name)) {
            return new CsdlComplexType().setName(name).setOpenType(true);
        }
        return null;
    }

    public List<CsdlComplexType> getComplexTypes() {
        List<CsdlComplexType> complexTypes;
        int previousSize;
        this.getEntityTypes();
        this.getActions();
        this.getFunctions();
        do {
            previousSize = this.complexTypeLookup.size();
            complexTypes = new HashSet<Map.Entry<String, CdsStructuredTypeInfo>>(this.complexTypeLookup.entrySet()).stream().map(e -> this.buildComplexType((String)e.getKey(), (CdsStructuredTypeInfo)e.getValue())).toList();
        } while (previousSize != this.complexTypeLookup.size());
        return complexTypes;
    }

    private CsdlComplexType buildComplexType(String name, CdsStructuredTypeInfo typeInfo) {
        CdsStructuredType type = typeInfo.type();
        return (CsdlComplexType)this.cached.computeIfAbsent((CdsDefinition)type, s -> {
            CsdlComplexType complexType = new CsdlComplexType();
            complexType.setName(name);
            complexType.setOpenType(((Boolean)type.getAnnotationValue("open", (Object)false)).booleanValue());
            this.flavourMapper.createMappings(type).forEach(mapped -> {
                if (mapped.getTargetElement().getType().isAssociation()) {
                    complexType.getNavigationProperties().add(this.createNavigationProperty((EdmxFlavourMapper.Mapping)mapped, type, typeInfo.isKey()));
                } else if (CdsServiceEdmUtils.isIncluded(mapped.getTargetElement())) {
                    complexType.getProperties().add(this.createProperty((EdmxFlavourMapper.Mapping)mapped, complexType.getName(), typeInfo.isKey()));
                }
            });
            return complexType;
        });
    }

    private void addKeyPaths(CdsElement keyElement, CsdlEntityType entityType) {
        ElementUtils.keyPaths(keyElement).forEach(keyPath -> {
            String name = keyPath;
            String alias = null;
            int lastDot = keyPath.lastIndexOf(46);
            if (lastDot != -1) {
                name = keyPath.replace('.', '/');
                alias = keyPath.substring(lastDot + 1);
            }
            entityType.getKey().add(new CsdlPropertyRef().setName(name).setAlias(alias));
        });
    }

    private CsdlProperty createProperty(EdmxFlavourMapper.Mapping mapping, String parentName, boolean isKey) {
        CsdlProperty property = new CsdlProperty();
        property.setName(mapping.getEdmxName());
        CdsElement element = mapping.getTargetElement();
        property.setType(this.type(element.getType(), (CdsAnnotatable)element, def -> CdsServiceEdmUtils.nameElement((CdsDefinition)def, parentName, mapping.getEdmxName())));
        property.setCollection(element.getType().isArrayed());
        boolean notNull = this.flavour == EdmxFlavourMapper.EdmxFlavour.X4 && isKey || mapping.getRootElement().isKey() || element.isNotNull();
        property.setNullable(!notNull);
        if (element.getType().isSimple()) {
            SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)element.getType().as(CdsSimpleType.class), property.getType(), (CdsAnnotatable)element);
            property.setMaxLength(properties.maxLength());
            property.setPrecision(properties.precision());
            property.setScale(properties.scale());
            property.setScaleAsString(properties.scaleAsString());
            property.setSrid(properties.srid());
        }
        return property;
    }

    private CsdlNavigationProperty createNavigationProperty(EdmxFlavourMapper.Mapping mapping, CdsStructuredType declarator, boolean isKey) {
        CdsElement assoc = mapping.getTargetElement();
        CdsEntity target = CdsServiceEdmUtils.target(declarator, assoc);
        CsdlNavigationProperty navProperty = new CsdlNavigationProperty();
        navProperty.setName(mapping.getEdmxName());
        navProperty.setType(CdsServiceEdmUtils.fqn((CdsDefinition)target) + (CdsServiceEdmUtils.isParameterized(target) ? "Parameters" : ""));
        navProperty.setCollection(CdsModelUtils.isToMany((CdsType)assoc.getType()));
        boolean notNull = this.flavour == EdmxFlavourMapper.EdmxFlavour.X4 && (isKey || mapping.getRootElement().isKey()) || assoc.isNotNull();
        navProperty.setNullable(Boolean.valueOf(!notNull));
        navProperty.setContainsTarget(((Boolean)declarator.getAnnotationValue("odata.contained", (Object)(DraftUtils.isDraftEnabled((CdsAnnotatable)declarator) && assoc.getName().equals("DraftAdministrativeData") ? 1 : 0))).booleanValue());
        return navProperty;
    }

    public List<CsdlAction> getActions(String name) {
        List<CdsOperationInfo<CdsAction>> actions = this.actionLookup.get(name);
        if (actions != null) {
            return actions.stream().map(this::buildAction).toList();
        }
        return Collections.emptyList();
    }

    public List<CsdlAction> getActions() {
        return this.actionLookup.values().stream().flatMap(Collection::stream).map(this::buildAction).toList();
    }

    private CsdlAction buildAction(CdsOperationInfo<CdsAction> info) {
        CdsAction action = info.operation();
        return (CsdlAction)this.cached.computeIfAbsent((CdsDefinition)action, a -> {
            CsdlAction csdlAction = new CsdlAction();
            csdlAction.setName(CdsServiceEdmUtils.name((CdsDefinition)action));
            if (action instanceof CdsBoundAction) {
                CdsBoundAction boundAction = (CdsBoundAction)action;
                csdlAction.setBound(true);
                csdlAction.getParameters().add(this.createBindingParameter(boundAction.getBindingParameter(), (CdsOperation)action, info.boundTo()));
            }
            action.parameters().forEach(parameter -> csdlAction.getParameters().add(this.createParameter((CdsParameter)parameter, (CdsOperation)action)));
            action.returnType().ifPresent(type -> csdlAction.setReturnType(this.createReturnType((CdsType)type, (CdsOperation)action)));
            return csdlAction;
        });
    }

    public List<CsdlFunction> getFunctions(String name) {
        List<CdsOperationInfo<CdsFunction>> functions = this.functionLookup.get(name);
        if (functions != null) {
            return functions.stream().map(this::buildFunction).toList();
        }
        return Collections.emptyList();
    }

    public List<CsdlFunction> getFunctions() {
        return this.functionLookup.values().stream().flatMap(Collection::stream).map(this::buildFunction).toList();
    }

    private CsdlFunction buildFunction(CdsOperationInfo<CdsFunction> info) {
        CdsFunction function = info.operation();
        return (CsdlFunction)this.cached.computeIfAbsent((CdsDefinition)function, f -> {
            CsdlFunction csdlFunction = new CsdlFunction();
            csdlFunction.setName(CdsServiceEdmUtils.name((CdsDefinition)function));
            if (function instanceof CdsBoundFunction) {
                CdsBoundFunction boundFunction = (CdsBoundFunction)function;
                csdlFunction.setBound(true);
                csdlFunction.getParameters().add(this.createBindingParameter(boundFunction.getBindingParameter(), (CdsOperation)function, info.boundTo()));
            }
            function.parameters().forEach(parameter -> csdlFunction.getParameters().add(this.createParameter((CdsParameter)parameter, (CdsOperation)function)));
            csdlFunction.setReturnType(this.createReturnType(function.getReturnType(), (CdsOperation)function));
            return csdlFunction;
        });
    }

    private CsdlParameter createBindingParameter(CdsParameter bindingParameter, CdsOperation operation, CdsEntity boundTo) {
        boolean notNull;
        boolean isCollection;
        String bindingParameterName;
        if (bindingParameter != null) {
            bindingParameterName = bindingParameter.getName();
            isCollection = bindingParameter.getType().isArrayed();
            notNull = bindingParameter.isNotNull();
        } else {
            bindingParameterName = (String)operation.getAnnotationValue("cds.odata.bindingparameter.name", (Object)"in");
            isCollection = (Boolean)operation.getAnnotationValue("cds.odata.bindingparameter.collection", (Object)false);
            notNull = false;
        }
        CsdlParameter csdlBindingParameter = new CsdlParameter();
        csdlBindingParameter.setName(bindingParameterName);
        csdlBindingParameter.setType(CdsServiceEdmUtils.fqn((CdsDefinition)boundTo) + (CdsServiceEdmUtils.isParameterized(boundTo) ? "Type" : ""));
        csdlBindingParameter.setCollection(isCollection);
        csdlBindingParameter.setNullable(!notNull);
        return csdlBindingParameter;
    }

    private CsdlParameter createParameter(CdsParameter parameter, CdsOperation operation) {
        CsdlParameter csdlParameter = new CsdlParameter();
        csdlParameter.setName(parameter.getName());
        csdlParameter.setType(this.type(parameter.getType(), (CdsAnnotatable)parameter, def -> CdsServiceEdmUtils.nameParameter((CdsDefinition)def, operation, parameter)));
        csdlParameter.setCollection(parameter.getType().isArrayed());
        csdlParameter.setNullable(!parameter.isNotNull());
        if (parameter.getType().isSimple()) {
            SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)parameter.getType().as(CdsSimpleType.class), csdlParameter.getType(), (CdsAnnotatable)parameter);
            csdlParameter.setMaxLength(properties.maxLength());
            csdlParameter.setPrecision(properties.precision());
            csdlParameter.setScale(properties.scale());
            csdlParameter.setSrid(properties.srid());
        }
        return csdlParameter;
    }

    private CsdlReturnType createReturnType(CdsType type, CdsOperation operation) {
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType(this.type(type, (CdsAnnotatable)type, def -> CdsServiceEdmUtils.nameReturn((CdsDefinition)def, operation)));
        returnType.setCollection(type.isArrayed());
        returnType.setNullable(true);
        if (type.isSimple()) {
            SimpleTypeProperties properties = CdsServiceEdmSchema.simpleTypeProperties((CdsSimpleType)type.as(CdsSimpleType.class), returnType.getType(), (CdsAnnotatable)type);
            returnType.setMaxLength(properties.maxLength());
            returnType.setPrecision(properties.precision());
            returnType.setScale(properties.scale());
            returnType.setSrid(properties.srid());
        }
        return returnType;
    }

    private FullQualifiedName type(CdsType type, CdsAnnotatable declarator, Function<CdsStructuredType, String> anonymousNameSupplier) {
        if (type.isStructured()) {
            CdsStructuredType structuredType = (CdsStructuredType)type.as(CdsStructuredType.class);
            FullQualifiedName fqn = CdsServiceEdmUtils.structuredTypeFqn(this.service, structuredType, anonymousNameSupplier);
            if (type.getKind() != CdsKind.ENTITY) {
                CdsElement e;
                boolean isKey = declarator instanceof CdsElement && (e = (CdsElement)declarator).isKey() && structuredType.isAnonymous();
                this.complexTypeLookup.put(fqn.getName(), new CdsStructuredTypeInfo(structuredType, isKey));
            }
            return fqn;
        }
        if (type.isArrayed()) {
            return this.type(((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType(), declarator, anonymousNameSupplier);
        }
        if (type.isSimple()) {
            String edmType = CdsServiceEdmSchema.isODataTypeAnnotated(declarator) ? (String)declarator.getAnnotationValue("odata.Type", null) : (declarator != null && CdsAnnotations.CORE_MEDIA_TYPE.getOrDefault(declarator) != null ? "Edm.Stream" : (type.isSimpleType(CdsBaseType.MAP) ? "com.sap.cds_Map" : CdsServiceEdmSchema.simpleType(((CdsSimpleType)type.as(CdsSimpleType.class)).getType())));
            return new FullQualifiedName(edmType);
        }
        return null;
    }

    private static String simpleType(CdsBaseType type) {
        return switch (type) {
            case CdsBaseType.UUID -> "Edm.Guid";
            case CdsBaseType.BOOLEAN -> "Edm.Boolean";
            case CdsBaseType.UINT8, CdsBaseType.HANA_TINYINT -> "Edm.Byte";
            case CdsBaseType.INT16, CdsBaseType.HANA_SMALLINT -> "Edm.Int16";
            case CdsBaseType.INT32, CdsBaseType.INTEGER -> "Edm.Int32";
            case CdsBaseType.INT64, CdsBaseType.INTEGER64 -> "Edm.Int64";
            case CdsBaseType.DECIMAL, CdsBaseType.HANA_SMALLDECIMAL -> "Edm.Decimal";
            case CdsBaseType.HANA_REAL -> "Edm.Single";
            case CdsBaseType.DOUBLE -> "Edm.Double";
            case CdsBaseType.DATE -> "Edm.Date";
            case CdsBaseType.TIME -> "Edm.TimeOfDay";
            case CdsBaseType.DATETIME, CdsBaseType.TIMESTAMP -> "Edm.DateTimeOffset";
            case CdsBaseType.STRING, CdsBaseType.LARGE_STRING, CdsBaseType.HANA_CHAR, CdsBaseType.HANA_NCHAR, CdsBaseType.HANA_VARCHAR, CdsBaseType.HANA_CLOB -> "Edm.String";
            case CdsBaseType.BINARY, CdsBaseType.LARGE_BINARY, CdsBaseType.HANA_BINARY -> "Edm.Binary";
            case CdsBaseType.HANA_ST_POINT -> "Edm.GeometryPoint";
            case CdsBaseType.HANA_ST_GEOMETRY -> "Edm.Geometry";
            default -> null;
        };
    }

    private static SimpleTypeProperties simpleTypeProperties(CdsSimpleType simpleType, String edmType, CdsAnnotatable declarator) {
        Object sridObj;
        boolean hasOdataType = CdsServiceEdmSchema.isODataTypeAnnotated(declarator);
        Integer maxLength = null;
        if (MAX_LENGTH_FACET_TYPES.contains(edmType)) {
            maxLength = hasOdataType ? (Integer)declarator.getAnnotationValue("odata.MaxLength", null) : (Integer)simpleType.get("length");
        }
        Integer precision = null;
        if (PRECISION_FACET_TYPES.contains(edmType)) {
            precision = hasOdataType ? (Integer)declarator.getAnnotationValue("odata.Precision", null) : (simpleType.getType() == CdsBaseType.TIMESTAMP ? Integer.valueOf(7) : (Integer)simpleType.get("precision"));
        }
        Integer scale = null;
        String scaleAsString = null;
        if ("Edm.Decimal".equals(edmType)) {
            if (hasOdataType) {
                Object scaleObj = declarator.getAnnotationValue("odata.Scale", null);
                if (scaleObj instanceof Integer) {
                    Integer s;
                    scale = s = (Integer)scaleObj;
                    scaleAsString = String.valueOf(s);
                } else if (scaleObj instanceof String) {
                    String s;
                    scaleAsString = s = (String)scaleObj;
                }
            } else {
                scale = (Integer)simpleType.get("scale");
                if (scale != null) {
                    scaleAsString = String.valueOf(scale);
                }
                if (precision == null && scale == null) {
                    scale = Constants.VARIABLE_SCALE;
                    scaleAsString = "variable";
                }
            }
        }
        SRID srid = null;
        if (SRID_FACET_TYPES.contains(edmType) && (sridObj = hasOdataType ? declarator.getAnnotationValue("odata.SRID", null) : simpleType.get("srid")) != null) {
            srid = SRID.valueOf((String)sridObj.toString());
        }
        return new SimpleTypeProperties(maxLength, precision, scale, scaleAsString, srid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isODataTypeAnnotated(CdsAnnotatable element) {
        if (element == null) return false;
        if (!element.findAnnotation("odata.Type").map(CdsAnnotation::getValue).filter(ALL_TYPES::contains).isPresent()) return false;
        return true;
    }

    private static <T> List<T> addOrInit(List<T> list, T value) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(value);
        return list;
    }

    private record CdsEntityInfo(CdsEntity entity, EntityTypeKind kind) {
    }

    private static enum EntityTypeKind {
        DEFAULT,
        PARAMETERIZED_PARAMETERS,
        PARAMETERIZED_TYPE;

    }

    private record CdsStructuredTypeInfo(CdsStructuredType type, boolean isKey) {
    }

    record SimpleTypeProperties(Integer maxLength, Integer precision, Integer scale, String scaleAsString, SRID srid) {
    }

    private record CdsOperationInfo<T extends CdsOperation>(T operation, CdsEntity boundTo) {
    }
}

