/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.utils;

import com.sap.cds.services.changeset.ChangeSetContextSPI;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.ProxyInputStream;

public class ChangeSetContextAwareInputStream
extends ProxyInputStream {
    private final ChangeSetContextSPI changeSetContext;
    private final AtomicBoolean unclosedChangeSetTracker;

    public ChangeSetContextAwareInputStream(InputStream in, ChangeSetContextSPI changeSetContext, AtomicBoolean unclosedChangeSetTracker) {
        super(Objects.requireNonNull(in));
        this.changeSetContext = Objects.requireNonNull(changeSetContext);
        this.unclosedChangeSetTracker = Objects.requireNonNull(unclosedChangeSetTracker);
    }

    public void close() throws IOException {
        try {
            this.changeSetContext.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.unclosedChangeSetTracker.set(false);
        }
        super.close();
    }

    protected void afterRead(int n) throws IOException {
        if (n == -1) {
            try {
                this.changeSetContext.close();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this.unclosedChangeSetTracker.set(false);
            }
        }
    }

    protected void handleIOException(IOException e) throws IOException {
        try {
            this.changeSetContext.markForCancel();
            this.changeSetContext.close();
        }
        catch (Exception e1) {
            throw new IOException(e1);
        }
        finally {
            this.unclosedChangeSetTracker.set(false);
        }
        throw e;
    }
}

