/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4;

import com.sap.cds.adapter.edmx.EdmxV4Provider;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper.EdmxFlavour;
import com.sap.cds.services.runtime.CdsRuntime;

public class CdsODataV4ServletFactory extends AbstractCdsODataServletFactory {

	static final String PROTOCOL_KEY = "odata-v4";

	public CdsODataV4ServletFactory() {
		super(PROTOCOL_KEY, r -> r.getEnvironment().getCdsProperties().getOdataV4().getEndpoint(), CdsODataV4Servlet::new);
	}

	private static class CdsODataV4Servlet extends AbstractCdsODataServlet {

		public CdsODataV4Servlet(CdsRuntime runtime, String basePath) {
			super(runtime, basePath, determineFlavour(runtime), PROTOCOL_KEY, () -> runtime.getProvider(EdmxV4Provider.class));
		}

		private static EdmxFlavour determineFlavour(CdsRuntime runtime) {
			boolean ucsn = runtime.getEnvironment().getCdsProperties().getModel().getUniversalCsn().isEnabled();
			return ucsn ? EdmxFlavour.V4 : EdmxFlavour.NOOP; // noop used for V4 in OData CSN
		}

	}

}
