/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4;

import com.sap.cds.adapter.edmx.EdmxX4Provider;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper.EdmxFlavour;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class CdsODataX4ServletFactory extends AbstractCdsODataServletFactory {

	static final String PROTOCOL_KEY = "odata-x4";

	public CdsODataX4ServletFactory() {
		super(PROTOCOL_KEY, r -> r.getEnvironment().getCdsProperties().getOdataX4().getEndpoint(), CdsODataX4Servlet::new);
	}

	private static class CdsODataX4Servlet extends AbstractCdsODataServlet {

		public CdsODataX4Servlet(CdsRuntime runtime, String basePath) {
			super(runtime, basePath, determineFlavour(runtime), PROTOCOL_KEY, () -> runtime.getProvider(EdmxX4Provider.class));
		}

		private static EdmxFlavour determineFlavour(CdsRuntime runtime) {
			if (!runtime.getEnvironment().getCdsProperties().getModel().getUniversalCsn().isEnabled()) {
				throw new ErrorStatusException(CdsErrorStatuses.X4_UNSUPPORTED);
			}
			return EdmxFlavour.X4;
		}

	}

}
