/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.adapter.IndexContentProviderFactory;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;

public class ODataX4IndexContentProviderFactory implements IndexContentProviderFactory, CdsRuntimeAware {

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public IndexContentProvider create() {
		return new ODataX4IndexContentProvider(runtime);
	}

	@Override
	public boolean isEnabled() {
		return runtime.getEnvironment().getCdsProperties().getOdataX4().getEndpoint().isEnabled();
	}

}
