/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.metadata.provider;

import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;

import com.sap.cds.adapter.edmx.EdmxProvider;

/**
 * This version allows to cache the {@link CsdlEdmProvider} in addition.
 */
public interface OlingoAwareEdmxProvider extends EdmxProvider {

	/**
	 * Returns the {@link CsdlEdmProvider} for the given service.
	 *
	 * @param serviceName the name of the service
	 * @return the {@link CsdlEdmProvider}
	 */
	CsdlEdmProvider getEdmProvider(String serviceName);

}
