/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.preview;

import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;

public class CdsFioriPreviewServletFactory implements ServletAdapterFactory, CdsRuntimeAware {

	static final String BASE_PATH = "/$fiori-preview";

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Object create() {
		return new CdsFioriPreviewServlet(runtime);
	}

	@Override
	public boolean isEnabled() {
		CdsProperties properties = runtime.getEnvironment().getCdsProperties();
		return properties.getOdataV4().getEndpoint().isEnabled() &&
			properties.getOdataV4().getFioriPreview().isEnabled() &&
			properties.getIndexPage().isEnabled();
	}

	@Override
	public String getBasePath() {
		return BASE_PATH;
	}

	@Override
	public String[] getMappings() {
		return new String[] { BASE_PATH + "/**" };
	}

	@Override
	public UrlResourcePath getServletPath() {
		return UrlResourcePathBuilder.path(BASE_PATH).recursive().isPublic(false).build();
	}

}
