/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.processors.response;

import java.util.List;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.services.application.ErrorResponseEventContext.ErrorResponse;
import com.sap.cds.services.messages.Message;

public class CdsODataResponse {

	private final int statusCode;
	private final Result result;
	private final NextLinkInfo nextLinkInfo;

	private final String contentType;
	private final String contentDispositionFilename;

	private List<Message> errorMessages;
	private final String contentDispositionType;

	// SUCCESS
	public CdsODataResponse(int statusCode, Result result, NextLinkInfo nextLinkInfo, String contentType, String contentDispositionFilename, String contentDispositionType) {
		this.statusCode = statusCode;
		this.result = result;
		this.nextLinkInfo = nextLinkInfo;
		this.contentType = contentType;
		this.contentDispositionFilename = contentDispositionFilename;
		this.contentDispositionType = contentDispositionType;
	}

	public CdsODataResponse(int statusCode, Result result) {
		this(statusCode, result, null, null, null, null);
	}

	public CdsODataResponse(int statusCode) {
		this(statusCode, (Result) null);
	}

	// ERRORS
	public CdsODataResponse(ErrorResponse errorResponse) {
		this(errorResponse.getHttpStatus());
		this.errorMessages = errorResponse.getMessages();
	}

	public boolean isSuccess() {
		return statusCode < 400;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public Result getResult() {
		return result;
	}

	public NextLinkInfo getNextLinkInfo() {
		return nextLinkInfo;
	}

	public List<Message> getErrorMessages() {
		return errorMessages;
	}

	public String getContentType() {
		return this.contentType;
	}

	public String getContentDispositionFilename() {
		return contentDispositionFilename;
	}

	public String getContentDispositionType() {
		return contentDispositionType;
	}

}
