/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.olingo.server.api.uri.queryoption.apply.Aggregate;
import org.apache.olingo.server.api.uri.queryoption.apply.AggregateExpression;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.transformation.CqnAggregateTransformation;
import com.sap.cds.ql.impl.transformations.AggregateTrafo;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class AggregateConverter {

	private AggregateConverter() {
		// empty
	}

	public static CqnAggregateTransformation of(Aggregate agg, ExpressionParser expressionParser) {
		List<CqnSelectListValue> items = new ArrayList<>();

		ElementAggregator aggregator = new ElementAggregator(expressionParser);
		List<AggregateExpression> agExps = agg.getExpressions();
		for (AggregateExpression agExp : agExps) {
			if (agExp.getInlineAggregateExpression() != null) {
				throw new ErrorStatusException(CdsErrorStatuses.UNSUPPORTED_APPLY_OPTION, agExp.getPath().toArray());
			}
			Value<?> func;
			String alias;
			if (agExp.getExpression() != null) {
				// Simple aggregation queries like aggregate(price with sum as Total)
				func = aggregator.genericAggregate(agExp.getExpression(), agExp.getStandardMethod());
				alias = agExp.getAlias();
			} else {
				// Custom Aggregates
				String path = agExp.getPath().stream().map(p -> p.getSegmentValue()).collect(Collectors.joining("."));
				func = aggregator.customAggregate(agExp.getPath());
				alias = path.startsWith("$") ? agExp.getAlias() : path;
			}
			items.add(func.as(alias));
		}

		return AggregateTrafo.aggregate(items);
	}
}
