/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Filter;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.cqn.transformation.CqnFilterTransformation;
import com.sap.cds.ql.impl.transformations.FilterTrafo;

public class FilterConverter {

	private FilterConverter() {
		// empty
	}

	public static CqnFilterTransformation of(Filter odataFilter, ExpressionParser expressionParser) {
		FilterOption filterOption = odataFilter.getFilterOption();

		return FilterTrafo.filter(expressionParser.parseFilter(filterOption.getExpression()));
	}

}
