/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import java.util.ArrayList;
import java.util.List;

import org.apache.olingo.server.api.uri.queryoption.apply.GroupBy;
import org.apache.olingo.server.api.uri.queryoption.apply.GroupByItem;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.transformations.GroupByTrafo;

public class GroupByConverter {

	private GroupByConverter() {
		// empty
	}

	public static CqnTransformation of(GroupBy gBy, ExpressionParser expressionParser) {
		List<CqnElementRef> dimensions = new ArrayList<>(gBy.getGroupByItems().size());
		List<CqnTransformation> transformations = new ArrayList<>();

		// group by dimensions
		for (GroupByItem gByItem : gBy.getGroupByItems()) {
			ElementRef<?> ref = CQL.get(expressionParser.toSegmentList(gByItem.getPath()));
			dimensions.add(ref.as(ref.path()));
		}

		if (gBy.getApplyOption() != null) {
			// handle aggregations
			ApplyHandler applyHandler = ApplyHandler.create(gBy.getApplyOption(), expressionParser);
			transformations.addAll(applyHandler.getTransformations(0));
		}

		return GroupByTrafo.groupBy(dimensions).transformations(transformations);
	}

}
