/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import static com.sap.cds.ql.CQL.sort;
import static com.sap.cds.ql.cqn.CqnSortSpecification.Order.ASC;
import static com.sap.cds.ql.cqn.CqnSortSpecification.Order.DESC;

import java.util.ArrayList;
import java.util.List;

import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.apply.OrderBy;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.transformations.OrderByTrafo;

public class OrderByConverter {

	private OrderByConverter() {
		// empty
	}

	public static List<CqnSortSpecification> toSortSpecs(OrderByOption orderBy, ExpressionParser expressionParser) {
		List<CqnSortSpecification> sortList = new ArrayList<>();
		for (OrderByItem order : orderBy.getOrders()) {
			CqnValue value = expressionParser.parseValue(order.getExpression());
			sortList.add(sort(value, order.isDescending() ? DESC : ASC));
		}
		return sortList;
	}

	public static CqnTransformation of(OrderBy orderBy, ExpressionParser expressionParser) {
		return OrderByTrafo.orderBy(toSortSpecs(orderBy.getOrderByOption(), expressionParser));
	}

}
