/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.query.apply;

import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.apply.Search;
import org.apache.olingo.server.api.uri.queryoption.search.SearchBinary;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.transformations.SearchTrafo;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

public class SearchConverter {

	private SearchConverter() {
		// empty
	}

	public static Predicate convertSearchOption(SearchOption searchOption) {
		return toCqnPredicate(searchOption.getSearchExpression());
	}

	public static Predicate toCqnPredicate(SearchExpression expr) {
		if (expr.isSearchBinary()) {
			SearchBinary binary = expr.asSearchBinary();
			switch (binary.getOperator()) {
				case AND:
					return CQL.and(toCqnPredicate(binary.getLeftOperand()), toCqnPredicate(binary.getRightOperand()));
				case OR:
					return CQL.or(toCqnPredicate(binary.getLeftOperand()), toCqnPredicate(binary.getRightOperand()));
				default:
					throw new ErrorStatusException(ErrorStatuses.NOT_IMPLEMENTED);
			}
		}
		if (expr.isSearchUnary()) {
			return CQL.not(toCqnPredicate(expr.asSearchUnary().getOperand()));
		}
		if (expr.isSearchTerm()) {
			return CQL.search(expr.asSearchTerm().getSearchTerm());
		}
		throw new ErrorStatusException(ErrorStatuses.NOT_IMPLEMENTED);
	}

	public static CqnTransformation of(Search odataSearch) {
		return SearchTrafo.search(toCqnPredicate(odataSearch.getSearchOption().getSearchExpression()));
	}

}
