/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;

import org.apache.olingo.commons.api.edm.EdmBindingTarget;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;

public class Entity2Json extends Struct2Json {

	// cached calculation:
	Map<Map<String, Object>, String> calculatedId = new IdentityHashMap<>();
	Map<Map<String, Object>, String> calculatedKeyPredicate = new IdentityHashMap<>();
	EdmBindingTarget bindingTarget;
	Function<Map<String, Object>, String> keyPredicate; // not serialized
	String2Json<Map<String, Object>> id;

	Entity2Json() {
	}

	public String2Json<Map<String, Object>> id() {
		return id;
	}

	public Function<Map<String, Object>, String> keyPredicate() {
		return keyPredicate;
	}

	@Override
	public void toJson(Map<String, Object> row, JsonGenerator json) throws IOException {
		if (row == null) {
			json.writeNull();
			return;
		}

		json.writeStartObject();
		if (isRootLevel) {
			if (context != null) {
				context.toJson(null, json);
			}
			if (metadataEtag != null) {
				metadataEtag.toJson(null, json);
			}
		}
		if (etag != null) {
			etag.toJson(row, json);
		}
		if (id != null) {
			id.toJson(row, json);
		}
		if (type != null) {
			type.toJson(null, json);
		}
		writeProperties(row, json);
		json.writeEndObject();
	}

}
