/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.format.ContentType;

import com.sap.cds.adapter.odata.v4.serializer.json.options.NavigationProperty2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.options.Struct2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.options.StructCollection2JsonOptions;

public class NavigationProperty2JsonBuilder {

	/* Create navigation link to an associated entity */
	public static NavigationProperty2Json createNavigation(
			EdmElement navigationProperty, ContentType contentType, NavigationProperty2JsonOptions options,
			boolean isStructProperty) {

		String propertyName = navigationProperty.getName();
		NavigationProperty2Json navigationProperty2Json = new NavigationProperty2Json();
		navigationProperty2Json.navigationProperty = propertyName;
		navigationProperty2Json.valueFunc = StructTypeHelper.fromProperty(propertyName, options.isOmitNulls());

		EdmStructuredType type = (EdmStructuredType) navigationProperty.getType();
		if (navigationProperty.isCollection()) {
			if (options.isCountPath()) {
				// $count at the end of the path. Only count is rendered.
				return inlineCount(contentType, options, propertyName);
			} else if (options.getCount() != null) {
				// Inline count generated with the collection
				navigationProperty2Json.inlineCount = inlineCount(contentType, options, propertyName);
			}
		}

		if (navigationProperty.isCollection()) {
			StructCollection2JsonOptions entityOptions = StructCollection2JsonOptions
					.with(contentType, options.getODataVersion(), options.getGlobals(), options.getPreferenceApplied())
					.count(options.getCount())
					.expand(options.getExpand())
					.select(options.getSelect())
					.writeOnlyReferences(options.getWriteOnlyReferences())
					.autoExpand(options.isAutoExpand())
					.build();
			navigationProperty2Json.entityCollection2Json = isStructProperty
					? ComplexCollection2JsonBuilder.createExpanded(entityOptions, type, contentType,
							propertyName)
					: EntityCollection2JsonBuilder.createExpanded(entityOptions, type, contentType,
							propertyName);
		} else {
			Struct2JsonOptions entityOptions = Struct2JsonOptions
					.with(contentType, options.getODataVersion(), options.getGlobals(), options.getPreferenceApplied())
					.expand(options.getExpand())
					.select(options.getSelect())
					.writeOnlyReferences(options.getWriteOnlyReferences())
					.autoExpand(options.isAutoExpand())
					.build();
			navigationProperty2Json.struct2Json = isStructProperty
					? Complex2JsonBuilder.createNested(entityOptions, type, contentType)
					: Entity2JsonBuilder.createNested(entityOptions, type, contentType);
		}
		return navigationProperty2Json;
	}

	private static InlineCount2Json inlineCount(ContentType contentType, NavigationProperty2JsonOptions options, String propertyName) {
		NavigationProperty2JsonOptions entityOptions = NavigationProperty2JsonOptions
			.with(contentType, options.getODataVersion(), options.getGlobals(), options.getPreferenceApplied()).build();
		return new InlineCount2Json(propertyName, entityOptions);
	}
}
