/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json;

import java.net.URI;
import java.util.Map;

import org.apache.olingo.commons.api.IConstants;

import com.sap.cds.adapter.odata.v4.serializer.json.options.StructCollection2JsonOptions;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.Number2Json;
import com.sap.cds.adapter.odata.v4.serializer.json.primitive.String2Json;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;

/**
 * Abstract builder for both collections of complex types and entities.
 */
public abstract class StructCollection2JsonBuilder {

	@SuppressWarnings({ "unchecked" })
	static void addCountAndNextLink(StructCollection2Json collection2Json, StructCollection2JsonOptions options,
			URI nextLinkUri, String navigationPropertyName, Long inlineCount) {
		IConstants constants = options.getConstants();
		// $count
		Number2Json<?> count = null;
		String2Json<?> countStr = null;
		if (options.getCount() != null && options.getCount().getValue()) {
			if (navigationPropertyName == null) {
				// system query ?$count=true
				if (inlineCount == -1) {
					throw new ErrorStatusException(CdsErrorStatuses.MISSING_VALUE_FOR_COUNT);
				}
				if (options.isIEEE754Compatible()) {
					countStr = String2Json.constant(constants.getCount(), String.valueOf(inlineCount));
				} else {
					count = Number2Json.constant(constants.getCount(), inlineCount);
				}
			}
		}
		collection2Json.count = (Number2Json<Iterable<Map<String, Object>>>) count;
		collection2Json.countStr = (String2Json<Iterable<Map<String, Object>>>) countStr;

		if (nextLinkUri != null) {
			collection2Json.nextLink = String2Json.constant(constants.getNextLink(), nextLinkUri.toASCIIString());
		}
	}
}
