/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.api;

import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;

public class PropertyInfo {
	private final String name;
	private final EdmType type;
	private final boolean isCollection;

	private final boolean isOmitNulls;

	public static PropertyInfo from(EdmProperty edmProperty) {
		return from(edmProperty, false);
	}

	public static PropertyInfo from(EdmProperty edmProperty, boolean isOmitNulls) {
		return new PropertyInfo(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(),
				isOmitNulls);
	}

	public static PropertyInfo create(String name, EdmType type, boolean isCollection) {
		return new PropertyInfo(name, type, isCollection, false);
	}

	private PropertyInfo(String name, EdmType type, boolean isCollection, boolean isOmitNulls) {
		this.name = name;
		this.type = type;
		this.isCollection = isCollection;
		this.isOmitNulls = isOmitNulls;
	}

	public String getName() {
		return name;
	}

	public EdmType getType() {
		return type;
	}

	public boolean isCollection() {
		return isCollection;
	}

	public boolean isOmitNulls() {
		return isOmitNulls;
	}
}
