/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.options;

import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.uri.queryoption.CountOption;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;

public class Apply2JsonOptions extends CdsODataOptions {

	private CountOption count;

	/** Gets the $count system query option. */
	public CountOption getCount() {
		return count;
	}

	private Apply2JsonOptions(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
		super(contentType, odataVersion, globals, null);
	}

	/** Initializes the options builder. */
	public static Builder with(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
		return new Builder(contentType, odataVersion, globals);
	}

	/** Builder of OData serializer options. */
	public static final class Builder {

		private final Apply2JsonOptions options;

		private Builder(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
			options = new Apply2JsonOptions(contentType, odataVersion, globals);
		}

		/** Sets the {@link ContextURL}. */
		public Builder contextURL(final ContextURL contextURL) {
			options.contextURL = contextURL;
			return this;
		}

		/** Sets the $count system query option. */
		public Builder count(final CountOption count) {
			options.count = count;
			return this;
		}

		/** Builds the OData serializer options. */
		public Apply2JsonOptions build() {
			return options;
		}
	}
}
