/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.options;

import java.util.Map;

import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;

import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;

/**
 * Options for the Complex2Json and Entity2Json serializers.
 */
public class Struct2JsonOptions extends CdsODataOptions {

	protected ExpandOption expand;
	protected SelectOption select;
	private boolean writeOnlyReferences;
	private String derivedTypeName;
	private boolean autoExpand;

	public ExpandOption getExpand() {
		return expand;
	}

	public SelectOption getSelect() {
		return select;
	}

	/** Gets the {@link ContextURL}. */
	public ContextURL getContextURL() {
		return contextURL;
	}

	/** only writes the references of the entities */
	public boolean getWriteOnlyReferences() {
		return writeOnlyReferences;
	}

	public String getDerivedTypeName() {
		return derivedTypeName;
	}

	public boolean isAutoExpand() {
		return autoExpand;
	}


	private Struct2JsonOptions(ContentType contentType, String odataVersion, CdsRequestGlobals globals,
			Map<String, String> preferenceApplied) {
		super(contentType, odataVersion, globals, preferenceApplied);

	}

	/** Initializes the options builder. */
	public static Builder with(ContentType contentType, String odataVersion, CdsRequestGlobals globals) {
		return with(contentType, odataVersion, globals, null);
	}

	public static Builder with(ContentType contentType, String odataVersion, CdsRequestGlobals globals,
			Map<String, String> preferenceApplied) {
		return new Builder(contentType, odataVersion, globals, preferenceApplied);
	}

	/** Builder of OData serializer options. */
	public static final class Builder {

		private final Struct2JsonOptions options;

		private Builder(ContentType contentType, String odataVersion, CdsRequestGlobals globals,
				Map<String, String> preferenceApplied) {
			options = new Struct2JsonOptions(contentType, odataVersion, globals, preferenceApplied);
		}

		/** Sets the {@link ContextURL}. */
		public Builder contextURL(ContextURL contextURL) {
			options.contextURL = contextURL;
			return this;
		}

		/** Sets the $expand system query option. */
		public Builder expand(ExpandOption expand) {
			options.expand = expand;
			return this;
		}

		/** Sets the $select system query option. */
		public Builder select(SelectOption select) {
			options.select = select;
			return this;
		}

		/** Sets to serialize only references */
		public Builder writeOnlyReferences(boolean refsOnly) {
			options.writeOnlyReferences = refsOnly;
			return this;
		}

		public Builder derivedTypeName(String typeName) {
			options.derivedTypeName = typeName;
			return this;
		}

		public Builder autoExpand(boolean autoExpand) {
			options.autoExpand = autoExpand;
			return this;
		}

		/** Builds the OData serializer options. */
		public Struct2JsonOptions build() {
			return options;
		}
	}
}
