package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;
import com.sap.cds.adapter.odata.v4.serializer.json.StructTypeHelper;
import com.sap.cds.adapter.odata.v4.serializer.json.api.Data2Json;

public abstract class AbstractPrimitiveData2Json<T, V> implements Data2Json<T> {

	protected final Function<T, V> valueFunc;

	protected AbstractPrimitiveData2Json(Function<T, V> valueFunc) {
		this.valueFunc = valueFunc;
	}

	public void toJson(T data, JsonGenerator json) throws IOException {
		V val = valueFunc.apply(data);
		if (val != StructTypeHelper.NOOP) {
			write(val, json);
		}
	};

	@Override
	public V getValue(T data) {
		return valueFunc.apply(data);
	}

	protected abstract void write(V value, JsonGenerator json) throws IOException;
}
