/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;

public class Boolean2Json<T> extends AbstractPrimitiveData2Json<T, Boolean> {

	private final String name;

	private Boolean2Json(String name, Function<T, Boolean> valueFunc) {
		super(valueFunc);
		this.name = name;
	}

	public static <T> Boolean2Json<T> val(String name, Function<T, Boolean> valueFunc) {
		return new Boolean2Json<T>(name, valueFunc);
	}

	public static Boolean2Json<?> constant(String name, Boolean value) {
		return new Boolean2Json<>(name, fixed -> value);
	}

	@Override
	protected void write(Boolean val, JsonGenerator json) throws IOException {
		json.writeFieldName(name);
		if (val != null) {
			json.writeBoolean(val);
		} else {
			json.writeNull();
		}
	}

	@Override
	public String getName() {
		return name;
	}
}
