/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;

public class BooleanArray2Json<T> extends AbstractPrimitiveData2Json<T, List<Boolean>> {
	private final String name;

	private BooleanArray2Json(String name, Function<T, List<Boolean>> valueFunc) {
		super(valueFunc);
		this.name = name;
	}

	public static <T> BooleanArray2Json<T> val(String name, Function<T, List<Boolean>> valueFunc) {
		return new BooleanArray2Json<T>(name, valueFunc);
	}

	@Override
	protected void write(List<Boolean> val, JsonGenerator json) throws IOException {
		json.writeFieldName(name);
		json.writeStartArray();
		if (val != null) {
			for (Boolean v : val) {
				if (v != null) {
					json.writeBoolean(v);
				} else {
					json.writeNull();
				}
			}
		}
		json.writeEndArray();
	}

	@Override
	public String getName() {
		return name;
	}
}
