/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;

public class DecimalArray2Json<T> extends AbstractPrimitiveData2Json<T, List<BigDecimal>> {

	private final String name;

	private DecimalArray2Json(String name, Function<T, List<BigDecimal>> valueFunc) {
		super(valueFunc);
		this.name = name;
	}

	public static <T> DecimalArray2Json<T> val(String name, Function<T, List<BigDecimal>> valueFunc) {
		return new DecimalArray2Json<T>(name, valueFunc);
	}

	@Override
	protected void write(List<BigDecimal> values, JsonGenerator json) throws IOException {
		json.writeFieldName(name);
		json.writeStartArray();
		if (values != null) {
			for (BigDecimal v : values) {
				if (v != null) {
					json.writeNumber(v);
				} else {
					json.writeNull();
				}
			}
		}
		json.writeEndArray();
	}

	@Override
	public String getName() {
		return name;
	}
}
