/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;

public class NumberArray2Json<T> extends AbstractPrimitiveData2Json<T, List<Number>> {

	private final String name;

	private NumberArray2Json(String name, Function<T, List<Number>> valueFunc) {
		super(valueFunc);
		this.name = name;
	}

	public static <T> NumberArray2Json<T> val(String name, Function<T, List<Number>> valueFunc) {
		return new NumberArray2Json<T>(name, valueFunc);
	}

	@Override
	protected void write(List<Number> values, JsonGenerator json) throws IOException {
		json.writeFieldName(name);
		json.writeStartArray();
		if (values != null) {
			for (Number v : (List<Number>) values) {
				if (v != null) {
					json.writeNumber(String.valueOf(v));
				} else {
					json.writeNull();
				}
			}
		}
		json.writeEndArray();
	}

	@Override
	public String getName() {
		return name;
	}
}
