/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;

public class String2Json<T> extends AbstractPrimitiveData2Json<T, Object> {

	private final String name;

	private String2Json(String name, Function<T, Object> valueFunc) {
		super(valueFunc);
		this.name = name;
	}

	public static <T> String2Json<T> val(String name, Function<T, Object> valueFunc) {
		return new String2Json<T>(name, valueFunc);
	}

	public static <T> String2Json<T> constant(String name, Object value) {
		return new String2Json<T>(name, fixed -> value);
	}

	@Override
	protected void write(Object value, JsonGenerator json) throws IOException {
		json.writeFieldName(name);
		if (value != null) {
			String strValue = String.valueOf(value);
			json.writeString(strValue);
		} else {
			json.writeNull();
		}
	}

	@Override
	public String getName() {
		return name;
	}
}
