/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.serializer.json.primitive;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;

import com.fasterxml.jackson.core.JsonGenerator;

public class StringArray2Json<T> extends AbstractPrimitiveData2Json<T, List<Object>> {

	private final String name;

	private StringArray2Json(String name, Function<T, List<Object>> valueFunc) {
		super(valueFunc);
		this.name = name;
	}

	public static <T> StringArray2Json<T> val(String name, Function<T, List<Object>> valueFunc) {
		return new StringArray2Json<T>(name, valueFunc);
	}

	@Override
	protected void write(List<Object> values, JsonGenerator json) throws IOException {
		json.writeFieldName(name);
		json.writeStartArray();
		if (values != null) {
			for (Object v : values) {
				if (v != null) {
					String strValue = String.valueOf(v);
					json.writeString(strValue);
				} else {
					json.writeNull();
				}
			}
		}
		json.writeEndArray();
	}

	@Override
	public String getName() {
		return name;
	}
}
