/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v4.utils;

import java.util.Map;

import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.services.utils.model.CdsAnnotations;

public class StreamUtils {

	private StreamUtils() {
		// hidden
	}

	public static String getCoreMediaTypeElement(CdsStructuredType entity, String elementName) {
		return getAnnotationElement(CdsAnnotations.CORE_MEDIA_TYPE, entity, elementName);
	}

	public static String getCoreMediaTypeValue(CdsEntity cdsEntity, String elementName) {
		return getAnnotationValue(CdsAnnotations.CORE_MEDIA_TYPE, cdsEntity, elementName);
	}

	public static String getContentDispositionElement(CdsEntity cdsEntity, String elementName) {
		return getAnnotationElement(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, cdsEntity, elementName);
	}

	public static String getContentDispositionValue(CdsEntity cdsEntity, String elementName) {
		return getAnnotationValue(CdsAnnotations.CORE_CONTENT_DISPOSITION_FILENAME, cdsEntity, elementName);
	}

	public static String getContentDispositionTypeValue(CdsEntity cdsEntity, String elementName) {
		return getAnnotationValue(CdsAnnotations.CORE_CONTENT_DISPOSITION_TYPE, cdsEntity, elementName);
	}

	@SuppressWarnings("unchecked")
	private static String getAnnotationElement(CdsAnnotations annotation, CdsStructuredType entity, String elementName) {
		return entity.findElement(elementName)
				.map(e -> annotation.getOrDefault(e))
				.filter(a -> a instanceof Map)
				.map(a -> ((Map<String, String>) a).get("="))
				.orElse(null);
	}

	private static String getAnnotationValue(CdsAnnotations annotation, CdsEntity cdsEntity, String elementName) {
		return cdsEntity.findElement(elementName)
				.map(e -> annotation.getOrDefault(e))
				.filter(a -> a instanceof String)
				.map(a -> (String) a)
				.orElse(null);
	}

}
