/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata.provider;

import com.google.common.hash.Hashing;
import com.sap.cds.adapter.edmx.EdmxI18nProvider;
import com.sap.cds.adapter.edmx.EdmxProvider;
import com.sap.cds.adapter.odata.v4.metadata.provider.EdmxI18nInputStream;
import com.sap.cds.adapter.odata.v4.metadata.provider.OlingoAwareEdmxProvider;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;

public class LocalizingEdmxProviderWrapper
implements OlingoAwareEdmxProvider {
    private static final EdmxI18nProvider NOOP = new EdmxI18nProvider(){

        public String getETag(Locale locale) {
            return null;
        }

        public Map<String, String> getTexts(Locale locale) {
            return Collections.emptyMap();
        }
    };
    private final EdmxProvider provider;
    private final EdmxI18nProvider i18nProvider;
    private final Locale locale;

    public LocalizingEdmxProviderWrapper(EdmxProvider provider, EdmxI18nProvider i18nProvider, Locale locale) {
        this.provider = provider;
        this.i18nProvider = i18nProvider != null ? i18nProvider : NOOP;
        this.locale = locale;
    }

    public String getETag(String serviceName) {
        String eTag = this.provider.getETag(serviceName);
        String i18nETag = this.i18nProvider.getETag(this.locale);
        if (i18nETag == null) {
            return eTag;
        }
        return Hashing.sha256().hashUnencodedChars((CharSequence)(eTag + i18nETag)).toString();
    }

    public InputStream getEdmx(String serviceName) {
        InputStream original = this.provider.getEdmx(serviceName);
        Map i18n = this.i18nProvider.getTexts(this.locale);
        if (!i18n.isEmpty()) {
            return new EdmxI18nInputStream(original, i18n);
        }
        return original;
    }

    @Override
    public CsdlEdmProvider getEdmProvider(String serviceName) {
        CsdlEdmProvider csdlEdmProvider;
        EdmxProvider edmxProvider = this.provider;
        if (edmxProvider instanceof OlingoAwareEdmxProvider) {
            OlingoAwareEdmxProvider withEdm = (OlingoAwareEdmxProvider)edmxProvider;
            csdlEdmProvider = withEdm.getEdmProvider(serviceName);
        } else {
            csdlEdmProvider = null;
        }
        return csdlEdmProvider;
    }
}

