/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.processors;

import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.Row;
import com.sap.cds.SessionContext;
import com.sap.cds.adapter.odata.v4.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v4.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v4.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v4.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v4.query.SystemQueryLoader;
import com.sap.cds.adapter.odata.v4.utils.ETagHelper;
import com.sap.cds.adapter.odata.v4.utils.EdmUtils;
import com.sap.cds.adapter.odata.v4.utils.ElementUtils;
import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.adapter.odata.v4.utils.QueryLimitUtils;
import com.sap.cds.adapter.odata.v4.utils.StreamUtils;
import com.sap.cds.adapter.odata.v4.utils.TypeConverterUtils;
import com.sap.cds.adapter.odata.v4.utils.mapper.EdmxFlavourMapper;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.cds.CdsReadEventContext;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ListUtils;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmOperation;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourcePrimitiveProperty;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.UriResourceValue;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CdsProcessor.class);
    private static final Result NOT_MODIFIED = ResultBuilder.selectedRows(Collections.emptyList()).result();
    private final CdsRequestGlobals globals;
    private final EdmxFlavourMapper requestMapper;
    private final EdmxFlavourMapper responseMapper;
    private final EdmUtils edmUtils;
    private CdsProperties cdsProperties;

    public CdsProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.cdsProperties = globals.getRuntime().getEnvironment().getCdsProperties();
        this.requestMapper = EdmxFlavourMapper.create(globals.getEdmxFlavour(), true);
        this.responseMapper = EdmxFlavourMapper.create(globals.getEdmxFlavour(), false);
        this.edmUtils = new EdmUtils(globals);
    }

    public void processRequest(CdsODataRequest request, Consumer<CdsODataResponse> responseProcessor) {
        ChangeSetContext changeSetContext = ChangeSetContext.getCurrent();
        if (changeSetContext == null) {
            this.globals.getRuntime().changeSetContext().run(context -> {
                this.processRequest(request, responseProcessor, (ChangeSetContext)context);
                return null;
            });
        } else {
            this.processRequest(request, responseProcessor, changeSetContext);
        }
    }

    private void processRequest(CdsODataRequest cdsRequest, Consumer<CdsODataResponse> responseProcessor, ChangeSetContext changeSetContext) {
        this.globals.getRuntime().requestContext().clearMessages().parameters((ParameterInfo)cdsRequest).run(requestContext -> {
            CdsODataResponse response;
            try {
                response = this.delegateRequest(cdsRequest);
            }
            catch (ServiceException e) {
                this.markForCancel(changeSetContext, e);
                if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                    logger.error(e.getMessage(), (Throwable)e);
                } else {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                response = ODataUtils.toErrorResponse(e, this.globals);
            }
            catch (Throwable e) {
                this.markForCancel(changeSetContext, e);
                logger.error(e.getMessage(), e);
                response = ODataUtils.toErrorResponse((ServiceException)new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e}), this.globals);
            }
            try {
                responseProcessor.accept(response);
            }
            catch (Throwable e) {
                this.markForCancel(changeSetContext, e);
                throw e;
            }
        });
    }

    private void markForCancel(ChangeSetContext changeSet, Throwable e) {
        changeSet.markForCancel();
        logger.info("Exception marked the ChangeSet {} as cancelled: {}", (Object)changeSet.getId(), (Object)e.getMessage());
    }

    private CdsODataResponse delegateRequest(CdsODataRequest request) {
        UriResource lastResource = request.getLastResource();
        HttpMethod method = request.getODataRequest().getMethod();
        UriResourceKind kind = lastResource.getKind();
        switch (kind) {
            case action: 
            case function: {
                return this.operation(request);
            }
            case primitiveProperty: 
            case complexProperty: 
            case value: {
                switch (method) {
                    case GET: {
                        return this.get(request, true);
                    }
                    case POST: {
                        boolean isCollection = false;
                        if (kind.equals((Object)UriResourceKind.complexProperty)) {
                            isCollection = ((UriResourceComplexProperty)lastResource).getProperty().isCollection();
                        } else if (kind.equals((Object)UriResourceKind.primitiveProperty)) {
                            isCollection = ((UriResourcePrimitiveProperty)lastResource).getProperty().isCollection();
                        }
                        if (isCollection) {
                            return this.patch(request);
                        }
                        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
                    }
                    case PUT: 
                    case DELETE: 
                    case PATCH: {
                        return this.patch(request);
                    }
                }
                throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
            }
        }
        switch (method) {
            case GET: {
                return this.get(request, true);
            }
            case POST: {
                return this.post(request);
            }
            case PUT: {
                return this.put(request);
            }
            case DELETE: {
                return this.delete(request);
            }
            case PATCH: {
                if (request.isDeltaCollection()) {
                    return this.deltaCollection(request);
                }
                return this.patch(request);
            }
        }
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    private CdsODataResponse get(CdsODataRequest request, boolean remap) {
        boolean readById;
        ApplicationService applicationService = this.globals.getApplicationService();
        CdsEntity entity = request.getLastEntity();
        CdsService cdsServiceModel = applicationService.getDefinition();
        String contentType = null;
        String contentDispoFilename = null;
        String contentDispoType = null;
        UriResource lastResource = request.getLastResource();
        UriInfo uriInfo = request.getUriInfo();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Select select = Select.from(this.toPathExpression(uriInfo.getUriResourceParts(), parameters));
        boolean preserveTrafos = false;
        preserveTrafos |= this.cdsProperties.getOdataV4().getApply().getTransformations().isEnabled().booleanValue();
        SystemQueryLoader queryLoader = SystemQueryLoader.create(this.requestMapper, this.globals.getEdmxFlavour(), this.cdsProperties, preserveTrafos |= CdsAnnotations.ODATA_APPLY_TRANSFORMATIONS.isTrue((CdsAnnotatable)cdsServiceModel));
        List<Select<?>> selects = queryLoader.updateSelectQuery(select, uriInfo, entity);
        String mediaTypeElementName = null;
        String contentDispoElementName = null;
        switch (lastResource.getKind()) {
            case primitiveProperty: 
            case complexProperty: {
                EdmProperty property = ((UriResourceProperty)lastResource).getProperty();
                String elementName = this.requestMapper.remap(property.getName(), (CdsStructuredType)entity);
                if (property.getType().getFullQualifiedName().getFullQualifiedNameAsString().equals("Edm.Stream")) {
                    ArrayList<Object> columns = new ArrayList<Object>();
                    columns.add(ElementUtils.aliasedGet(elementName));
                    mediaTypeElementName = StreamUtils.getCoreMediaTypeElement((CdsStructuredType)entity, elementName);
                    if (!StringUtils.isEmpty((CharSequence)mediaTypeElementName)) {
                        columns.add(CdsProcessor.getSelectListItem(mediaTypeElementName));
                    } else {
                        contentType = StreamUtils.getCoreMediaTypeValue(entity, elementName);
                    }
                    contentDispoElementName = StreamUtils.getContentDispositionElement(entity, elementName);
                    if (!StringUtils.isEmpty((CharSequence)contentDispoElementName)) {
                        columns.add(CdsProcessor.getSelectListItem(contentDispoElementName));
                    } else {
                        contentDispoFilename = StreamUtils.getContentDispositionValue(entity, elementName);
                    }
                    contentDispoType = StreamUtils.getContentDispositionTypeValue(entity, elementName);
                    select.columns(columns);
                    break;
                }
                select.columns(new Selectable[]{ElementUtils.aliasedGet(elementName)});
                break;
            }
            case count: {
                select.columns(new Selectable[]{CQL.count().as("count")});
                break;
            }
            case value: {
                UriResourcePartTyped lastTypedResource = request.getLastTypedResource();
                if (lastTypedResource.getKind() == UriResourceKind.primitiveProperty) {
                    EdmProperty valueProperty = ((UriResourcePrimitiveProperty)lastTypedResource).getProperty();
                    String valueElementName = this.requestMapper.remap(valueProperty.getName(), (CdsStructuredType)entity);
                    select.columns(new Selectable[]{ElementUtils.aliasedGet(valueElementName)});
                    break;
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{lastTypedResource.getKind()});
            }
            default: {
                selects.forEach(s -> queryLoader.updateSelectColumns((Select<?>)s, uriInfo, (CdsStructuredType)entity));
            }
        }
        boolean hasETag = ETagHelper.hasETag(entity);
        boolean keysSpecified = false;
        if (select.from().isRef()) {
            AnalysisResult analysis = CqnAnalyzer.create((CdsModel)this.globals.getModel()).analyze(select.ref());
            long keyCount = analysis.targetEntity().keyElements().count();
            keysSpecified = keyCount > 0L && (long)analysis.targetKeyValues().size() == keyCount;
        }
        boolean bl = readById = keysSpecified || !request.getLastEntityResource(true).isCollection();
        if (readById) {
            Select<?> readByIdSelect = selects.get(0);
            Result result = this.readById(request, applicationService, entity, parameters, readByIdSelect, hasETag);
            if (result == NOT_MODIFIED) {
                return new CdsODataResponse(304, result);
            }
            if (!StringUtils.isEmpty((CharSequence)mediaTypeElementName)) {
                contentType = (String)DataUtils.getOrDefault((Map)result.single(), (String)mediaTypeElementName, null);
            }
            if (!StringUtils.isEmpty((CharSequence)contentDispoElementName)) {
                contentDispoFilename = (String)DataUtils.getOrDefault((Map)result.single(), (String)contentDispoElementName, null);
            }
            if (remap) {
                result = this.remapResult(result, (CdsStructuredType)entity, (CqnSelect)readByIdSelect);
            }
            return new CdsODataResponse(200, result, null, contentType, contentDispoFilename, contentDispoType);
        }
        QueryLimitUtils queryLimitHandler = new QueryLimitUtils(cdsServiceModel, entity, uriInfo, this.cdsProperties.getQuery().getLimit());
        queryLimitHandler.handlePagination(selects);
        boolean analyticsQuery = uriInfo.getApplyOption() != null;
        Pair<Result, CqnSelect> resultPair = this.query(applicationService, entity, parameters, selects, analyticsQuery, remap);
        NextLinkInfo nextLinkInfo = queryLimitHandler.generateNextLink((Result)resultPair.getLeft(), (CqnSelect)resultPair.getRight());
        return new CdsODataResponse(200, (Result)resultPair.getLeft(), nextLinkInfo, contentType, contentDispoFilename, contentDispoType);
    }

    private Result readById(CdsODataRequest request, ApplicationService applicationService, CdsEntity entity, Map<String, Object> parameters, Select<?> select, boolean hasETag) {
        if (hasETag && ETagHelper.isETagHeaderInRequest(request)) {
            if (ETagHelper.hasStar(request, "If-None-Match")) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
            select = (Select)CqnUtils.addWhere(select, (CqnPredicate)ETagHelper.getETagPredicate(request, entity));
        }
        Result result = applicationService.run(select, parameters);
        long rowCount = result.rowCount();
        if (hasETag && ETagHelper.isETagHeaderInRequest(request) && rowCount == 0L) {
            if (request.getHeader("If-None-Match") != null) {
                return NOT_MODIFIED;
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
        }
        if (rowCount == 0L) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{entity.getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)this.globals.getModel(), (CqnStatement)select)});
        }
        return result;
    }

    private Pair<Result, CqnSelect> query(ApplicationService applicationService, CdsEntity entity, Map<String, Object> parameters, List<Select<?>> selects, boolean analyticsQuery, boolean remap) {
        ArrayList allRows = new ArrayList();
        long[] inlineCount = new long[selects.size()];
        CqnSelect statement = null;
        for (int i = 0; i < selects.size(); ++i) {
            Select<?> select = selects.get(i);
            CdsReadEventContext readEvent = CdsReadEventContext.create((String)entity.getQualifiedName());
            readEvent.setCqn(select);
            readEvent.setCqnNamedValues(parameters);
            applicationService.emit((EventContext)readEvent);
            Result result = readEvent.getResult();
            inlineCount[i] = result.inlineCount();
            if (analyticsQuery) {
                Set keys = select.items().stream().filter(sli -> sli.isValue()).map(sli -> sli.asValue().displayName()).collect(Collectors.toSet());
                result.forEach(r -> CdsProcessor.addNullsForOmittedValues((Map<String, Object>)r, keys));
            }
            if (remap) {
                result = this.remapResult(result, (CdsStructuredType)entity, (CqnSelect)select);
            }
            result.forEach(allRows::add);
            statement = i == 0 ? readEvent.getCqn() : null;
        }
        return Pair.of((Object)ResultBuilder.selectedRows(allRows).inlineCount(inlineCount[0]).result(), statement);
    }

    private static void addNullsForOmittedValues(Map<String, Object> r, Set<String> keys) {
        for (String key : keys) {
            CdsProcessor.addNullForOmittedValue(r, key);
        }
    }

    private static void addNullForOmittedValue(Map<String, Object> r, String key) {
        int i = key.indexOf(46);
        if (i == -1) {
            if (!r.containsKey(key)) {
                r.put(key, null);
            }
        } else {
            String seg = key.substring(0, i);
            Map inner = (Map)r.computeIfAbsent(seg, s -> new HashMap());
            CdsProcessor.addNullForOmittedValue(inner, key.substring(i + 1));
        }
    }

    private CdsODataResponse post(CdsODataRequest request) {
        ApplicationService applicationService = this.globals.getApplicationService();
        CdsEntity entity = request.getLastEntity();
        Map<String, Object> entityData = request.getBodyMap();
        StructuredType<?> ref = this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>());
        ref.filter((CqnPredicate)null);
        Insert insert = Insert.into(ref).entry(entityData);
        Object isActiveEntity = entityData.get("IsActiveEntity");
        Result result = DraftUtils.isDraftEnabled((CdsAnnotatable)entity) && (isActiveEntity == null || (Boolean)isActiveEntity == false) ? ((DraftService)applicationService).newDraft((CqnInsert)insert) : applicationService.run((CqnInsert)insert);
        return new CdsODataResponse(201, this.remapResult(result, (CdsStructuredType)entity, null));
    }

    private CdsODataResponse put(CdsODataRequest request) {
        CdsEntity entity = request.getLastEntity();
        Map<String, Object> entityData = request.getBodyMap();
        SessionContext sessionContext = SessionContextUtils.toSessionContext((RequestContext)RequestContext.getCurrent((CdsRuntime)this.globals.getRuntime()));
        DataUtils dataUtils = DataUtils.create(() -> sessionContext, (int)7);
        DataProcessor processor = DataProcessor.create().addGenerator((p, e, t) -> DataUtils.hasDefaultValue((CdsElement)e, (CdsType)t), (p, e, isNull) -> isNull ? null : dataUtils.defaultValue(e)).action(CdsProcessor::defaultToNull);
        processor.process(entityData, (CdsStructuredType)entity);
        return this.patch(request);
    }

    private static void defaultToNull(CdsStructuredType type, Map<String, Object> data) {
        ArrayList potentialFkElements = new ArrayList();
        Map<String, CdsElement> associations = ElementUtils.recursiveElements(type, e -> e.getType().isAssociation());
        associations.forEach((path, assoc) -> {
            final int firstDot = path.indexOf(".");
            ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).onCondition().ifPresent(p -> p.accept(new CqnVisitor(){
                final /* synthetic */ String val$path;
                final /* synthetic */ List val$potentialFkElements;
                {
                    this.val$path = string;
                    this.val$potentialFkElements = list;
                }

                public void visit(CqnElementRef elementRef) {
                    Stream<String> ids = elementRef.stream().map(CqnReference.Segment::id);
                    if (firstDot >= 0) {
                        String parentPath = this.val$path.substring(firstDot + 1);
                        ids = Stream.concat(Stream.of(parentPath), ids);
                    }
                    String fk = ids.collect(Collectors.joining("."));
                    this.val$potentialFkElements.add(fk);
                }
            }));
        });
        ElementUtils.recursiveElements(type, e -> !e.isKey() && !e.getType().isAssociation() && CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrDefault((CdsAnnotatable)e) == null).keySet().stream().filter(e -> !potentialFkElements.contains(e)).filter(e -> !DataUtils.containsKey((Map)data, (String)e, (boolean)true)).forEach(e -> DataUtils.putPath((Map)data, (String)e, null));
    }

    private CdsODataResponse deltaCollection(CdsODataRequest request) {
        List upsertData;
        ApplicationService applicationService = this.globals.getApplicationService();
        StructuredType<?> ref = this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>());
        Map<String, Object> bodyMap = request.getBodyMap();
        List deleteData = (List)bodyMap.get("cds.delete");
        if (!deleteData.isEmpty()) {
            CdsEntity entity = request.getLastEntity();
            Delete delete = Delete.from(ref).byParams((Collection)CdsModelUtils.keyNames((CdsStructuredType)entity));
            applicationService.run((CqnDelete)delete, (Iterable)deleteData);
        }
        if (!(upsertData = (List)bodyMap.get("cds.upsert")).isEmpty()) {
            Upsert upsert = Upsert.into(ref).entries((Iterable)upsertData);
            applicationService.run((CqnUpsert)upsert);
        }
        return new CdsODataResponse(204, ResultBuilder.insertedRows(Collections.emptyList()).result());
    }

    private CdsODataResponse patch(CdsODataRequest request) {
        ApplicationService applicationService = this.globals.getApplicationService();
        CdsEntity entity = request.getLastEntity();
        Map<String, Object> entityData = request.getBodyMap();
        StructuredType<?> ref = this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>());
        AnalysisResult analysis = CqnAnalyzer.create((CdsModel)this.globals.getModel()).analyze((CqnStructuredTypeRef)ref.asRef());
        entityData.putAll(analysis.targetKeyValues());
        boolean isStreamProperty = false;
        boolean isCollectionProperty = false;
        UriResource lastResource = request.getLastResource();
        String elementName = null;
        if (lastResource instanceof UriResourceProperty) {
            UriResourceProperty property = (UriResourceProperty)lastResource;
            EdmProperty edmProperty = property.getProperty();
            isCollectionProperty = edmProperty.isCollection();
            elementName = this.requestMapper.remap(edmProperty.getName(), (CdsStructuredType)entity);
            if (edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString().equals("Edm.Stream")) {
                isStreamProperty = true;
                String contentType = request.getHeader("Content-Type");
                String mediaTypeElement = StreamUtils.getCoreMediaTypeElement((CdsStructuredType)entity, elementName);
                if (mediaTypeElement != null) {
                    DataUtils.putPath(entityData, (String)mediaTypeElement, (Object)contentType);
                }
            }
        }
        if (elementName != null && isCollectionProperty && request.getODataRequest().getMethod().equals((Object)HttpMethod.POST)) {
            CdsODataResponse cdsODataResponse = this.get(request, false);
            Row row = cdsODataResponse.getResult().single();
            ArrayList existingValues = (ArrayList)row.get((Object)elementName);
            if (existingValues == null) {
                existingValues = new ArrayList();
            }
            List addedValues = (List)DataUtils.getOrDefault(entityData, (String)elementName, new ArrayList());
            existingValues.addAll(addedValues);
            DataUtils.putPath(entityData, (String)elementName, existingValues);
        }
        long rowCount = 0L;
        Result updateResult = null;
        boolean ifNoneMatchStar = ETagHelper.hasStar(request, "If-None-Match");
        if (!ifNoneMatchStar) {
            Update update = Update.entity(ref).data(entityData);
            boolean hasETag = ETagHelper.hasETag(entity);
            if (hasETag) {
                if (ETagHelper.isETagHeaderInRequest(request)) {
                    update = (CqnUpdate)CqnUtils.addWhere((CqnStatement)update, (CqnPredicate)ETagHelper.getETagPredicate(request, entity));
                } else {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
                }
            }
            updateResult = DraftUtils.isDraftTarget((CqnStructuredTypeRef)update.ref(), (CdsEntity)entity, (CdsModel)this.globals.getModel()) ? ((DraftService)applicationService).patchDraft((CqnUpdate)update, new Object[0]) : applicationService.run((CqnUpdate)update, new Object[0]);
            rowCount = updateResult.rowCount();
            if (hasETag && rowCount == 0L) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
        }
        if (rowCount == 0L) {
            if (lastResource instanceof UriResourcePrimitiveProperty || lastResource instanceof UriResourceValue) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{entity.getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)this.globals.getModel(), (CqnStructuredTypeRef)ref.asRef())});
            }
            if (ETagHelper.hasStar(request, "If-Match")) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
            try {
                return this.post(request);
            }
            catch (ServiceException e) {
                if (ifNoneMatchStar && e.getErrorStatus() == CdsErrorStatuses.UNIQUE_CONSTRAINT_VIOLATED) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[]{e});
                }
                throw e;
            }
        }
        if (request.getReturnPreference() != Preferences.Return.MINIMAL && !isStreamProperty) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Select<?> select = Select.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), parameters));
            select = SystemQueryLoader.create(this.requestMapper, this.globals.getEdmxFlavour(), this.cdsProperties).updateSelect(select, request.getUriInfo(), entity);
            Result readResult = applicationService.run(select, parameters);
            return new CdsODataResponse(200, this.remapResult(readResult, (CdsStructuredType)entity, (CqnSelect)select));
        }
        Map targetKeys = CqnAnalyzer.create((CdsModel)this.globals.getModel()).analyze((CqnStructuredTypeRef)ref.asRef()).targetKeyValues();
        updateResult.single().putAll(targetKeys);
        return new CdsODataResponse(204, this.remapResult(updateResult, (CdsStructuredType)entity, null));
    }

    private CdsODataResponse delete(CdsODataRequest request) {
        Result result;
        ApplicationService applicationService = this.globals.getApplicationService();
        Delete delete = Delete.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>()));
        CdsEntity entity = request.getLastEntity();
        boolean hasETag = ETagHelper.hasETag(entity);
        if (hasETag) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                if (ETagHelper.hasStar(request, "If-None-Match")) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
                delete = (CqnDelete)CqnUtils.addWhere((CqnStatement)delete, (CqnPredicate)ETagHelper.getETagPredicate(request, entity));
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
        if ((result = DraftUtils.isDraftTarget((CqnStructuredTypeRef)delete.ref(), (CdsEntity)entity, (CdsModel)this.globals.getModel()) ? ((DraftService)applicationService).cancelDraft((CqnDelete)delete, new Object[0]) : applicationService.run((CqnDelete)delete, new Object[0])).rowCount() == 0L) {
            if (hasETag) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{entity.getQualifiedName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)this.globals.getModel(), (CqnStatement)delete)});
        }
        return new CdsODataResponse(204);
    }

    private CdsODataResponse operation(CdsODataRequest request) {
        CdsType returnType;
        Result result;
        block11: {
            EventContext context;
            EdmOperation edmOperation = this.edmUtils.getEdmOperation((UriResource)request.getLastTypedResource());
            if (edmOperation.isBound()) {
                CdsEntity entity = request.getLastEntity();
                this.validateETagForWriteWithSelect(request, entity);
                context = EventContext.create((String)edmOperation.getName(), (String)entity.getQualifiedName());
                context.put("cqn", (Object)Select.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), new HashMap<String, Object>())));
            } else {
                context = EventContext.create((String)edmOperation.getName(), null);
            }
            request.getBodyMap().forEach((arg_0, arg_1) -> ((EventContext)context).put(arg_0, arg_1));
            this.globals.getApplicationService().emit(context);
            result = null;
            Object returnValue = context.get("result");
            returnType = this.edmUtils.getCdsOperationReturnType(this.edmUtils.getCdsOperation(request));
            if (returnValue != null) {
                try {
                    if (returnType != null && returnType.isSimple()) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put(edmOperation.getName(), returnValue);
                        result = ResultUtils.convert((Iterable)ListUtils.getList((Object[])new Map[]{data}));
                        break block11;
                    }
                    if (returnValue instanceof Iterable) {
                        result = ResultUtils.convert((Iterable)((Iterable)returnValue));
                        break block11;
                    }
                    if (returnValue instanceof Map) {
                        result = ResultUtils.convert((Iterable)ListUtils.getList((Object[])new Map[]{(Map)returnValue}));
                        break block11;
                    }
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{returnValue.getClass().getName()});
                }
                catch (ClassCastException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{returnValue.getClass().getName(), e});
                }
            }
        }
        if (returnType instanceof CdsStructuredType && result != null) {
            Select<?> select = null;
            if (returnType instanceof CdsEntity) {
                CdsEntity returnTypeEntity = (CdsEntity)returnType.as(CdsEntity.class);
                if (!this.matchesSelectExpand(result.list(), returnTypeEntity, request.getUriInfo().getSelectOption(), request.getUriInfo().getExpandOption())) {
                    ApplicationService applicationService = this.globals.getApplicationService();
                    select = Select.from((CdsEntity)returnTypeEntity);
                    select = SystemQueryLoader.create(this.requestMapper, this.globals.getEdmxFlavour(), this.cdsProperties).updateSelect(select, request.getUriInfo(), returnTypeEntity);
                    CqnSelect additionalSelect = (CqnSelect)CqnUtils.addWhere(select, (CqnPredicate)this.fetchKeyValuesFromResult(result, returnTypeEntity));
                    result = applicationService.run(additionalSelect, new Object[0]);
                }
            }
            result = this.remapResult(result, (CdsStructuredType)returnType.as(CdsStructuredType.class), (CqnSelect)select);
        }
        return new CdsODataResponse(200, result);
    }

    private boolean matchesSelectExpand(List<? extends Map<String, Object>> result, CdsEntity entity, SelectOption selectOption, ExpandOption expandOption) {
        boolean matches = true;
        if (selectOption != null) {
            matches = selectOption.getSelectItems().stream().allMatch(selectItem -> {
                if (selectItem.isStar()) {
                    Set<String> nonAssociationElementNames = ElementUtils.recursiveElements((CdsStructuredType)entity, e -> !e.getType().isAssociation()).keySet();
                    return result.stream().allMatch(map -> CdsProcessor.containsAll(map, nonAssociationElementNames));
                }
                if (selectItem.getResourcePath() != null) {
                    List uriResources = selectItem.getResourcePath().getUriResourceParts();
                    if (uriResources.size() > 1) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SELECT_PARSING_FAILED, new Object[0]);
                    }
                    String selectElement = this.requestMapper.remap(((UriResource)uriResources.get(0)).getSegmentValue(), (CdsStructuredType)entity);
                    return result.stream().allMatch(map -> DataUtils.containsKey((Map)map, (String)selectElement));
                }
                return true;
            });
        }
        if (matches && expandOption != null) {
            matches = expandOption.getExpandItems().stream().allMatch(expandItem -> {
                if (expandItem.isStar()) {
                    Set<String> associationElementNames = ElementUtils.recursiveElements((CdsStructuredType)entity, e -> e.getType().isAssociation()).keySet();
                    return result.stream().allMatch(map -> CdsProcessor.containsAll(map, associationElementNames));
                }
                if (expandItem.getResourcePath() != null) {
                    List uriResources = expandItem.getResourcePath().getUriResourceParts();
                    String expandElement = this.requestMapper.remap(((UriResource)uriResources.get(uriResources.size() - 1)).getSegmentValue(), (CdsStructuredType)entity);
                    boolean expandItemMatches = result.stream().allMatch(map -> DataUtils.containsKey((Map)map, (String)expandElement));
                    if (expandItemMatches) {
                        CdsEntity expandEntity = (CdsEntity)entity.getTargetOf(expandElement);
                        List expandResult = result.stream().map(map -> DataUtils.getOrDefault((Map)map, (String)expandElement, null)).flatMap(v -> {
                            if (v instanceof Map) {
                                return Stream.of((Map)v);
                            }
                            if (v instanceof Iterable) {
                                return StreamSupport.stream(((Iterable)v).spliterator(), false);
                            }
                            return Stream.empty();
                        }).collect(Collectors.toList());
                        return this.matchesSelectExpand(expandResult, expandEntity, expandItem.getSelectOption(), expandItem.getExpandOption());
                    }
                    return false;
                }
                return true;
            });
        }
        return matches;
    }

    private static boolean containsAll(Map<String, Object> data, Set<String> paths) {
        return data.keySet().containsAll(paths) || paths.stream().allMatch(p -> DataUtils.containsKey((Map)data, (String)p));
    }

    private Predicate fetchKeyValuesFromResult(Result result, CdsEntity entity) {
        List keyElements = entity.keyElements().map(k -> k.getName()).collect(Collectors.toList());
        BooleanValue predicate = CQL.FALSE;
        for (Row row : result.list()) {
            BooleanValue keys = CQL.TRUE;
            for (String key : keyElements) {
                keys = keys.and((CqnPredicate)CQL.get((String)key).eq(row.get((Object)key)), new CqnPredicate[0]);
            }
            predicate = predicate.or((CqnPredicate)keys, new CqnPredicate[0]);
        }
        return predicate;
    }

    private StructuredType<?> toPathExpression(List<UriResource> uriResources, Map<String, Object> parameters) {
        UriResource resource;
        if (uriResources.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_URI_RESOURCE, new Object[0]);
        }
        StructuredType parent = null;
        String currentEntityName = null;
        UriResource rootResource = uriResources.get(0);
        if (rootResource instanceof UriResourceEntitySet) {
            UriResourceEntitySet rootEntitySetResource = (UriResourceEntitySet)rootResource;
            Map<String, Object> keys = this.getFilterKeys(rootEntitySetResource.getKeyPredicates(), rootEntitySetResource.getEntityType().getKeyPropertyRefs());
            if (this.edmUtils.isParametersEntityType((EdmStructuredType)rootEntitySetResource.getEntityType())) {
                parameters.putAll(keys);
            } else {
                currentEntityName = this.edmUtils.getCdsEntityName((EdmStructuredType)rootEntitySetResource.getEntityType());
                Map<String, Object> mappedKeys = this.requestMapper.remap(keys, (CdsStructuredType)this.globals.getModel().getEntity(currentEntityName));
                parent = CQL.entity((String)currentEntityName).matching(mappedKeys);
            }
        } else if (rootResource instanceof UriResourceSingleton) {
            UriResourceSingleton rootSingletonResource = (UriResourceSingleton)rootResource;
            currentEntityName = this.edmUtils.getCdsEntityName((EdmStructuredType)rootSingletonResource.getEntityType());
            parent = CQL.entity((String)currentEntityName);
        } else {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNEXPECTED_URI_RESOURCE, new Object[]{rootResource.getKind()});
        }
        for (int i = 1; i < uriResources.size() && (resource = uriResources.get(i)) instanceof UriResourceNavigation; ++i) {
            UriResourceNavigation navigationResource = (UriResourceNavigation)resource;
            EdmEntityType navigationType = navigationResource.getProperty().getType();
            Map<String, Object> keys = this.getFilterKeys(navigationResource.getKeyPredicates(), navigationType.getKeyPropertyRefs());
            if (this.edmUtils.isParametersEntityType((EdmStructuredType)navigationType)) {
                parameters.putAll(keys);
                continue;
            }
            CdsEntity parentEntity = currentEntityName != null ? this.globals.getModel().getEntity(currentEntityName) : null;
            currentEntityName = this.edmUtils.getCdsEntityName((EdmStructuredType)navigationType);
            if (parent == null) {
                parent = CQL.entity((String)currentEntityName).matching(keys);
                continue;
            }
            String associationName = this.requestMapper.remap(navigationResource.getSegmentValue(), (CdsStructuredType)parentEntity);
            Map<String, Object> mappedKeys = this.requestMapper.remap(keys, (CdsStructuredType)this.globals.getModel().getEntity(currentEntityName));
            parent = parent.to(associationName).matching(mappedKeys);
        }
        if (parent == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PARAMETERIZED_VIEW, new Object[0]);
        }
        return parent;
    }

    private Map<String, Object> getFilterKeys(List<UriParameter> keyPreds, List<EdmKeyPropertyRef> keyRefs) {
        Map<String, EdmType> elementTypes = keyRefs.stream().collect(Collectors.toMap(k -> k.getName(), k -> k.getProperty().getType()));
        HashMap<String, Object> keys = new HashMap<String, Object>();
        for (UriParameter key : keyPreds) {
            String name = key.getName();
            String text = null;
            if (key.getAlias() != null) {
                Expression expression = key.getExpression();
                if (expression instanceof Literal) {
                    Literal literal = (Literal)expression;
                    text = literal.getText();
                }
            } else {
                text = key.getText();
            }
            keys.put(name, TypeConverterUtils.convertToType(elementTypes.get(name), text));
        }
        return keys;
    }

    private void validateETagForWriteWithSelect(CdsODataRequest request, CdsEntity cdsEntity) {
        boolean hasETag = ETagHelper.hasETag(cdsEntity);
        if (hasETag) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                Select select = Select.from(this.toPathExpression(request.getUriInfo().getUriResourceParts(), parameters));
                CqnSelect etagSelect = (CqnSelect)CqnUtils.addWhere((CqnStatement)select, (CqnPredicate)ETagHelper.getETagPredicate(request, cdsEntity));
                Result queryResult = (Result)this.globals.getRuntime().requestContext().clearMessages().run(requestContext -> this.globals.getApplicationService().run(etagSelect, parameters));
                long rowCount = queryResult.rowCount();
                boolean ifNoneMatchStar = ETagHelper.hasStar(request, "If-None-Match");
                if (rowCount == 0L && !ifNoneMatchStar || rowCount > 0L && ifNoneMatchStar) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
    }

    private Result remapResult(Result result, CdsStructuredType entryType, CqnSelect select) {
        return this.responseMapper.remap(result, entryType, path -> select != null ? this.isExpanded((String)path, select.items()) : false);
    }

    private boolean isExpanded(String path, List<CqnSelectListItem> items) {
        for (CqnSelectListItem item : items) {
            if (!item.isExpand()) continue;
            CqnExpand expand = item.asExpand();
            String displayName = expand.displayName();
            if (path.equals(displayName)) {
                return true;
            }
            if (!path.startsWith(displayName + ".")) continue;
            String remainingPath = path.substring(displayName.length() + 1);
            return this.isExpanded(remainingPath, expand.items());
        }
        return false;
    }

    protected static CqnSelectListItem getSelectListItem(String elementPath) {
        if (StringUtils.isEmpty((CharSequence)elementPath)) {
            return null;
        }
        String[] segments = elementPath.split("\\.");
        int length = segments.length;
        if (length == 1) {
            return CQL.get((String)segments[0]);
        }
        if (length == 2) {
            return CQL.to((String)segments[0]).expand(new String[]{segments[1]});
        }
        Expand expand = CQL.to((String)segments[length - 2]).expand(new String[]{segments[length - 1]});
        for (int i = length - 3; i >= 0; --i) {
            expand = CQL.to((String)segments[i]).expand(new Selectable[]{expand});
        }
        return expand;
    }
}

