/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.query.apply;

import com.sap.cds.adapter.odata.v4.query.ExpressionParser;
import com.sap.cds.adapter.odata.v4.query.apply.ApplyConverter;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.transformation.CqnTransformation;
import com.sap.cds.ql.impl.SelectBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.server.api.uri.queryoption.ApplyItem;
import org.apache.olingo.server.api.uri.queryoption.ApplyOption;

public class ApplyHandler {
    private final List<List<CqnTransformation>> unfoldedItems;
    private static final ApplyHandler NOOP = new ApplyHandler(List.of(), null);

    public ApplyHandler(List<ApplyItem> items, ExpressionParser expressionParser) {
        this.unfoldedItems = new ApplyConverter(expressionParser).unfoldAndConvert(items);
    }

    public List<CqnTransformation> getTransformations(int i) {
        return this.unfoldedItems.get(i);
    }

    public List<Select<?>> transform(Select<?> select) {
        ArrayList selects = new ArrayList(this.unfoldedItems.size());
        for (List<CqnTransformation> transformations : this.unfoldedItems) {
            SelectBuilder copy = SelectBuilder.copy(select);
            copy.transformations(transformations);
            selects.add((Select<?>)copy);
        }
        return selects;
    }

    public boolean hasConcat() {
        return this.unfoldedItems.size() > 1;
    }

    public static ApplyHandler create(ApplyOption applyOption, ExpressionParser expressionParser) {
        if (applyOption == null) {
            return NOOP;
        }
        return new ApplyHandler(applyOption.getApplyItems(), expressionParser);
    }
}

